<?php $__env->startSection('title', 'Editar Proyecto'); ?>
<?php $__env->startSection('page-title', 'Editar Proyecto: ' . $project->title); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-body">
                <form action="<?php echo e(route('admin.projects.update', $project)); ?>" method="POST" enctype="multipart/form-data" id="projectForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Título del Proyecto *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="title" name="title" value="<?php echo e(old('title', $project->title)); ?>" required>
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Descripción *</label>
                        <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="description" name="description" rows="5" required><?php echo e(old('description', $project->description)); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                   <?php echo e(old('is_active', $project->is_active) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Proyecto Activo
                            </label>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="main_image" class="form-label">Cambiar Imagen Principal</label>
                        <input type="file" class="form-control <?php $__errorArgs = ['main_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="main_image" name="main_image" accept="image/*">
                        <div class="form-text">
                            Deja vacío si no quieres cambiar la imagen principal actual.
                            Formatos: JPG, PNG, GIF, WEBP. Máximo: 5MB.
                        </div>
                        <?php $__errorArgs = ['main_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <!-- Preview nueva imagen principal -->
                        <div id="mainImagePreview" class="mt-2" style="display: none;">
                            <img id="mainImagePreviewImg" src="/placeholder.svg" class="img-thumbnail" style="max-width: 200px;">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="gallery_images" class="form-label">Agregar Imágenes a la Galería</label>
                        <input type="file" class="form-control <?php $__errorArgs = ['gallery_images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="gallery_images" name="gallery_images[]" multiple accept="image/*">
                        <div class="form-text">
                            Estas imágenes se agregarán a la galería existente. 
                            Puedes seleccionar múltiples imágenes. Máximo: 5MB cada una.
                        </div>
                        <?php $__errorArgs = ['gallery_images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <!-- Preview nuevas imágenes -->
                        <div id="galleryPreview" class="mt-2 row" style="display: none;"></div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(route('admin.projects.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Cancelar
                        </a>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-save me-2"></i>Actualizar Proyecto
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <!-- Imagen Principal Actual -->
        <?php if($project->mainImage): ?>
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fas fa-star me-2"></i>Imagen Principal Actual</h6>
            </div>
            <div class="card-body text-center">
                <img src="<?php echo e($project->mainImage->image_url); ?>" 
                     class="img-fluid rounded mb-2" 
                     style="max-height: 200px; object-fit: cover;">
                <p class="small text-muted mb-0"><?php echo e($project->mainImage->original_name); ?></p>
                <p class="small text-muted"><?php echo e($project->mainImage->formatted_file_size); ?></p>
            </div>
        </div>
        <?php endif; ?>

        <!-- Galería Actual -->
        <?php if($project->galleryImages->count() > 0): ?>
        <div class="card shadow mb-4">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <h6 class="mb-0"><i class="fas fa-images me-2"></i>Galería Actual (<?php echo e($project->galleryImages->count()); ?>)</h6>
            </div>
            <div class="card-body p-2">
                <div class="row">
                    <?php $__currentLoopData = $project->galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-6 mb-2">
                        <div class="position-relative">
                            <img src="<?php echo e($image->image_url); ?>" 
                                 class="img-fluid rounded" 
                                 style="width: 100%; height: 80px; object-fit: cover;">
                            <div class="position-absolute top-0 end-0 p-1">
                                <button type="button" class="btn btn-sm btn-outline-primary me-1" 
                                        onclick="setMainImage(<?php echo e($image->id); ?>)" 
                                        title="Hacer principal">
                                    <i class="fas fa-star"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                        onclick="deleteImage(<?php echo e($image->id); ?>)" 
                                        title="Eliminar">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                            <div class="position-absolute bottom-0 start-0 end-0 bg-dark bg-opacity-75 text-white p-1">
                                <small><?php echo e(Str::limit($image->original_name, 15)); ?></small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Información del Proyecto -->
        <div class="card shadow">
            <div class="card-header bg-secondary text-white">
                <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información del Proyecto</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <strong><i class="fas fa-calendar text-primary me-2"></i>Creado:</strong><br>
                        <span class="text-muted"><?php echo e($project->created_at->format('d/m/Y H:i')); ?></span>
                    </li>
                    <li class="mb-2">
                        <strong><i class="fas fa-edit text-primary me-2"></i>Actualizado:</strong><br>
                        <span class="text-muted"><?php echo e($project->updated_at->format('d/m/Y H:i')); ?></span>
                    </li>
                    <li class="mb-2">
                        <strong><i class="fas fa-image text-primary me-2"></i>Total Imágenes:</strong><br>
                        <span class="text-muted"><?php echo e($project->images->count()); ?> imagen(es)</span>
                    </li>
                    <li class="mb-0">
                        <strong><i class="fas fa-toggle-on text-primary me-2"></i>Estado:</strong><br>
                        <span class="badge <?php echo e($project->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                            <?php echo e($project->is_active ? 'Activo' : 'Inactivo'); ?>

                        </span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.preview-container {
    position: relative;
    display: inline-block;
}

.remove-preview {
    position: absolute;
    top: 5px;
    right: 5px;
    background: rgba(220, 53, 69, 0.8);
    color: white;
    border: none;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    font-size: 12px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}

.remove-preview:hover {
    background: rgba(220, 53, 69, 1);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Preview imagen principal
    const mainImageInput = document.getElementById('main_image');
    const mainImagePreview = document.getElementById('mainImagePreview');
    const mainImagePreviewImg = document.getElementById('mainImagePreviewImg');

    mainImageInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                mainImagePreviewImg.src = e.target.result;
                mainImagePreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            mainImagePreview.style.display = 'none';
        }
    });

    // Preview galería
    const galleryInput = document.getElementById('gallery_images');
    const galleryPreview = document.getElementById('galleryPreview');

    galleryInput.addEventListener('change', function(e) {
        galleryPreview.innerHTML = '';
        const files = Array.from(e.target.files);
        
        if (files.length > 0) {
            galleryPreview.style.display = 'flex';
            
            files.forEach((file, index) => {
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const col = document.createElement('div');
                        col.className = 'col-md-3 mb-2';
                        col.innerHTML = `
                            <div class="preview-container">
                                <img src="${e.target.result}" class="img-thumbnail" style="width: 100%; height: 80px; object-fit: cover;">
                                <button type="button" class="remove-preview" onclick="removeGalleryPreview(${index})">×</button>
                                <small class="d-block text-center mt-1">${file.name}</small>
                            </div>
                        `;
                        galleryPreview.appendChild(col);
                    };
                    reader.readAsDataURL(file);
                }
            });
        } else {
            galleryPreview.style.display = 'none';
        }
    });

    // Interceptar envío del formulario
    const form = document.getElementById('projectForm');
    const submitBtn = document.getElementById('submitBtn');

    form.addEventListener('submit', function(e) {
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Actualizando proyecto...';
        submitBtn.disabled = true;
    });
});

function removeGalleryPreview(index) {
    const galleryInput = document.getElementById('gallery_images');
    const dt = new DataTransfer();
    const files = Array.from(galleryInput.files);
    
    files.forEach((file, i) => {
        if (i !== index) {
            dt.items.add(file);
        }
    });
    
    galleryInput.files = dt.files;
    galleryInput.dispatchEvent(new Event('change'));
}

function deleteImage(imageId) {
    if (confirm('¿Estás seguro de eliminar esta imagen?')) {
        fetch(`/admin/projects/image/${imageId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                setTimeout(() => location.reload(), 1000);
            } else {
                showAlert('error', data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('error', 'Error al eliminar la imagen');
        });
    }
}

function setMainImage(imageId) {
    fetch(`/admin/projects/image/${imageId}/set-main`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('error', data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('error', 'Error al cambiar imagen principal');
    });
}

function showAlert(type, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    
    const content = document.querySelector('.col-lg-8 .card-body');
    content.insertAdjacentHTML('afterbegin', alertHtml);
    
    setTimeout(() => {
        const alert = content.querySelector('.alert');
        if (alert) {
            alert.remove();
        }
    }, 5000);
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\edelvalle\resources\views/admin/projects/edit.blade.php ENDPATH**/ ?>