<?php
    $siteSettings = App\Models\SiteSetting::getSettings();
?>
<!DOCTYPE html>
<html lang="es" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title><?php echo $__env->yieldContent('title', $siteSettings->site_name . ' - ' . ($siteSettings->site_tagline ?: 'Instalaciones Eléctricas')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('description', 'Empresa chilena especializada en instalaciones eléctricas, mantenimiento de redes y proyectos eléctricos rurales y urbanos.'); ?>">
    
    <?php if($siteSettings->favicon_path): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $siteSettings->favicon_path)); ?>">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: <?php echo e($siteSettings->primary_color); ?>;
            --secondary-color: <?php echo e($siteSettings->secondary_color); ?>;
            --success-color: <?php echo e($siteSettings->success_color); ?>;
            --warning-color: <?php echo e($siteSettings->warning_color); ?>;
            --danger-color: <?php echo e($siteSettings->danger_color); ?>;
            --dark-color: <?php echo e($siteSettings->dark_color); ?>;
        }
        
        .navbar-brand img {
            max-height: 50px;
        }
        
        .hero-section {
            background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), 
                        url('<?php echo e($siteSettings->hero_background_image ? asset('storage/' . $siteSettings->hero_background_image) : 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=1200&q=80'); ?>');
            background-size: cover;
            background-position: center;
            min-height: 70vh;
            display: flex;
            align-items: center;
            color: white;
        }
        
        .service-card {
            transition: transform 0.3s ease;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .service-card:hover {
            transform: translateY(-5px);
        }
        
        .project-card {
            overflow: hidden;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        
        .project-card:hover {
            transform: translateY(-5px);
        }
        
        .footer {
            background-color: var(--dark-color);
            color: white;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .text-primary {
            color: var(--primary-color) !important;
        }
        
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        
        .border-left-primary {
            border-left: 4px solid var(--primary-color) !important;
        }
        
        .border-left-success {
            border-left: 4px solid var(--success-color) !important;
        }
        
        .border-left-info {
            border-left: 4px solid #17a2b8 !important;
        }
        
        .border-left-warning {
            border-left: 4px solid var(--warning-color) !important;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <?php if($siteSettings->logo_path): ?>
                    <img src="<?php echo e(asset('storage/' . $siteSettings->logo_path)); ?>" alt="<?php echo e($siteSettings->site_name); ?>" class="img-fluid">
                <?php else: ?>
                    <img src="https://via.placeholder.com/150x50/<?php echo e(str_replace('#', '', $siteSettings->primary_color)); ?>/ffffff?text=<?php echo e(urlencode($siteSettings->site_name)); ?>" alt="<?php echo e($siteSettings->site_name); ?>" class="img-fluid">
                <?php endif; ?>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>" href="<?php echo e(route('home')); ?>">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>" href="<?php echo e(route('about')); ?>">Nosotros</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('services') ? 'active' : ''); ?>" href="<?php echo e(route('services')); ?>">Servicios</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('team') ? 'active' : ''); ?>" href="<?php echo e(route('team')); ?>">Equipo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('projects') ? 'active' : ''); ?>" href="<?php echo e(route('projects')); ?>">Proyectos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>" href="<?php echo e(route('contact')); ?>">Contacto</a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->is_admin): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Panel Admin</a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('logout')); ?>" 
                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                Salir
                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>">Acceso Admin</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="footer py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3"><?php echo e($siteSettings->site_name); ?></h5>
                    <p class="text-light">
                        <?php echo e($siteSettings->footer_text ?: 'Empresa chilena especializada en instalaciones eléctricas y mantenimiento de redes de distribución eléctrica desde 2021.'); ?>

                    </p>
                    <?php if($siteSettings->social_links): ?>
                        <div class="d-flex">
                            <?php if(isset($siteSettings->social_links['facebook'])): ?>
                                <a href="<?php echo e($siteSettings->social_links['facebook']); ?>" class="text-light me-3" target="_blank"><i class="fab fa-facebook-f"></i></a>
                            <?php endif; ?>
                            <?php if(isset($siteSettings->social_links['twitter'])): ?>
                                <a href="<?php echo e($siteSettings->social_links['twitter']); ?>" class="text-light me-3" target="_blank"><i class="fab fa-twitter"></i></a>
                            <?php endif; ?>
                            <?php if(isset($siteSettings->social_links['linkedin'])): ?>
                                <a href="<?php echo e($siteSettings->social_links['linkedin']); ?>" class="text-light me-3" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                            <?php endif; ?>
                            <?php if(isset($siteSettings->social_links['instagram'])): ?>
                                <a href="<?php echo e($siteSettings->social_links['instagram']); ?>" class="text-light" target="_blank"><i class="fab fa-instagram"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">Servicios</h5>
                    <ul class="list-unstyled text-light">
                        <li class="mb-2">Construcción de LMT y LBT</li>
                        <li class="mb-2">Instalación de Alumbrado Público</li>
                        <li class="mb-2">Obras Civiles</li>
                        <li class="mb-2">Líneas Eléctricas Subterráneas</li>
                        <li class="mb-2">Empalmes Monofásicos y Trifásicos</li>
                    </ul>
                </div>
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">Contacto</h5>
                    <div class="text-light">
                        <p class="mb-2"><i class="fas fa-map-marker-alt me-2"></i>Cerro Mejillón 1055, Parque Ñuble, Chillán</p>
                        <p class="mb-2"><i class="fas fa-phone me-2"></i>+56 9 3022 8380</p>
                        <p class="mb-2"><i class="fas fa-envelope me-2"></i>p.delvalle@energiadelvallespa.cl</p>
                        <p class="mb-0"><strong>RUT:</strong> 77.340.576-K</p>
                    </div>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="row">
                <div class="col-12 text-center">
                    <p class="text-light mb-0">&copy; <?php echo e(date('Y')); ?> <?php echo e($siteSettings->site_name); ?>. Todos los derechos reservados.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- AOS Animation -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\edelvalle\resources\views/layouts/app.blade.php ENDPATH**/ ?>