<?php $__env->startSection('title', 'Crear Proyecto'); ?>
<?php $__env->startSection('page-title', 'Crear Nuevo Proyecto'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-body">
                <form action="<?php echo e(route('admin.projects.store')); ?>" method="POST" enctype="multipart/form-data" id="projectForm">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Título del Proyecto *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="title" name="title" value="<?php echo e(old('title')); ?>" required>
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Descripción *</label>
                        <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="description" name="description" rows="5" required><?php echo e(old('description')); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                   <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Proyecto Activo
                            </label>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="main_image" class="form-label">Imagen Principal *</label>
                        <input type="file" class="form-control <?php $__errorArgs = ['main_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="main_image" name="main_image" accept="image/*" required>
                        <div class="form-text">
                            Esta imagen aparecerá en la lista de proyectos y como imagen destacada. 
                            Formatos: JPG, PNG, GIF, WEBP. Máximo: 5MB.
                        </div>
                        <?php $__errorArgs = ['main_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <!-- Preview imagen principal -->
                        <div id="mainImagePreview" class="mt-2" style="display: none;">
                            <img id="mainImagePreviewImg" src="/placeholder.svg" class="img-thumbnail" style="max-width: 200px;">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="gallery_images" class="form-label">Galería de Imágenes (Opcional)</label>
                        <input type="file" class="form-control <?php $__errorArgs = ['gallery_images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="gallery_images" name="gallery_images[]" multiple accept="image/*">
                        <div class="form-text">
                            Estas imágenes aparecerán en la galería interna del proyecto. 
                            Puedes seleccionar múltiples imágenes. Máximo: 5MB cada una.
                        </div>
                        <?php $__errorArgs = ['gallery_images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <!-- Preview galería -->
                        <div id="galleryPreview" class="mt-2 row" style="display: none;"></div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(route('admin.projects.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Cancelar
                        </a>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-save me-2"></i>Crear Proyecto
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <i class="fas fa-star text-warning me-2"></i>
                        <strong>Imagen Principal:</strong> Se mostrará en la lista de proyectos
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-images text-info me-2"></i>
                        <strong>Galería:</strong> Imágenes adicionales para el detalle del proyecto
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        <strong>Formatos:</strong> JPG, PNG, GIF, WEBP
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-weight-hanging text-secondary me-2"></i>
                        <strong>Tamaño máximo:</strong> 5MB por imagen
                    </li>
                    <li>
                        <i class="fas fa-eye text-primary me-2"></i>
                        <strong>Visibilidad:</strong> Solo proyectos activos aparecen en el sitio
                    </li>
                </ul>
            </div>
        </div>

        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="fas fa-lightbulb me-2"></i>Consejos</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0 small">
                    <li class="mb-2">• Usa imágenes de alta calidad para mejor presentación</li>
                    <li class="mb-2">• La imagen principal debe ser representativa del proyecto</li>
                    <li class="mb-2">• Puedes agregar más imágenes después de crear el proyecto</li>
                    <li>• Las imágenes se optimizan automáticamente</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.preview-container {
    position: relative;
    display: inline-block;
}

.remove-preview {
    position: absolute;
    top: 5px;
    right: 5px;
    background: rgba(220, 53, 69, 0.8);
    color: white;
    border: none;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    font-size: 12px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}

.remove-preview:hover {
    background: rgba(220, 53, 69, 1);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Preview imagen principal
    const mainImageInput = document.getElementById('main_image');
    const mainImagePreview = document.getElementById('mainImagePreview');
    const mainImagePreviewImg = document.getElementById('mainImagePreviewImg');

    mainImageInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                mainImagePreviewImg.src = e.target.result;
                mainImagePreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            mainImagePreview.style.display = 'none';
        }
    });

    // Preview galería
    const galleryInput = document.getElementById('gallery_images');
    const galleryPreview = document.getElementById('galleryPreview');

    galleryInput.addEventListener('change', function(e) {
        galleryPreview.innerHTML = '';
        const files = Array.from(e.target.files);
        
        if (files.length > 0) {
            galleryPreview.style.display = 'flex';
            
            files.forEach((file, index) => {
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const col = document.createElement('div');
                        col.className = 'col-md-3 mb-2';
                        col.innerHTML = `
                            <div class="preview-container">
                                <img src="${e.target.result}" class="img-thumbnail" style="width: 100%; height: 80px; object-fit: cover;">
                                <button type="button" class="remove-preview" onclick="removeGalleryPreview(${index})">×</button>
                                <small class="d-block text-center mt-1">${file.name}</small>
                            </div>
                        `;
                        galleryPreview.appendChild(col);
                    };
                    reader.readAsDataURL(file);
                }
            });
        } else {
            galleryPreview.style.display = 'none';
        }
    });

    // Interceptar envío del formulario
    const form = document.getElementById('projectForm');
    const submitBtn = document.getElementById('submitBtn');

    form.addEventListener('submit', function(e) {
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Creando proyecto...';
        submitBtn.disabled = true;
    });
});

function removeGalleryPreview(index) {
    const galleryInput = document.getElementById('gallery_images');
    const dt = new DataTransfer();
    const files = Array.from(galleryInput.files);
    
    files.forEach((file, i) => {
        if (i !== index) {
            dt.items.add(file);
        }
    });
    
    galleryInput.files = dt.files;
    galleryInput.dispatchEvent(new Event('change'));
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\edelvalle\resources\views/admin/projects/create.blade.php ENDPATH**/ ?>