<?php $__env->startSection('title', 'Ver Proyecto'); ?>
<?php $__env->startSection('page-title', 'Proyecto: ' . $project->title); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="btn-group">
    <a href="<?php echo e(route('admin.projects.edit', $project)); ?>" class="btn btn-warning">
        <i class="fas fa-edit me-2"></i>Editar
    </a>
    <a href="<?php echo e(route('project.detail', $project->id)); ?>" target="_blank" class="btn btn-info">
        <i class="fas fa-external-link-alt me-2"></i>Ver en Sitio
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-body">
                <h3 class="fw-bold mb-3"><?php echo e($project->title); ?></h3>
                
                <div class="mb-4">
                    <h5>Descripción:</h5>
                    <p class="text-muted" style="white-space: pre-line;"><?php echo e($project->description); ?></p>
                </div>

                <?php if($project->images->count() > 0): ?>
                <div class="mb-4">
                    <h5>Imágenes del Proyecto:</h5>
                    <div class="row">
                        <?php $__currentLoopData = $project->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4 mb-3">
                            <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" 
                                 class="img-fluid rounded shadow" 
                                 alt="<?php echo e($image->alt_text); ?>"
                                 data-bs-toggle="modal" 
                                 data-bs-target="#imageModal<?php echo e($image->id); ?>"
                                 style="cursor: pointer;">
                        </div>

                        <!-- Modal para imagen -->
                        <div class="modal fade" id="imageModal<?php echo e($image->id); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title"><?php echo e($project->title); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" 
                                             class="img-fluid" alt="<?php echo e($image->alt_text); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card shadow">
            <div class="card-header">
                <h6 class="mb-0">Información del Proyecto</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <strong>Estado:</strong>
                        <span class="badge <?php echo e($project->is_active ? 'bg-success' : 'bg-secondary'); ?> ms-2">
                            <?php echo e($project->is_active ? 'Activo' : 'Inactivo'); ?>

                        </span>
                    </li>
                    <li class="mb-2">
                        <strong>Fecha de Creación:</strong><br>
                        <?php echo e($project->created_at->format('d/m/Y H:i')); ?>

                    </li>
                    <li class="mb-2">
                        <strong>Última Actualización:</strong><br>
                        <?php echo e($project->updated_at->format('d/m/Y H:i')); ?>

                    </li>
                    <li class="mb-2">
                        <strong>Total de Imágenes:</strong><br>
                        <?php echo e($project->images->count()); ?> imagen(es)
                    </li>
                </ul>
            </div>
        </div>

        <div class="card shadow mt-4">
            <div class="card-header">
                <h6 class="mb-0">Acciones</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.projects.edit', $project)); ?>" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Editar Proyecto
                    </a>
                    <a href="<?php echo e(route('project.detail', $project->id)); ?>" target="_blank" class="btn btn-info">
                        <i class="fas fa-external-link-alt me-2"></i>Ver en Sitio Web
                    </a>
                    <a href="<?php echo e(route('admin.projects.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Volver a Lista
                    </a>
                    <form action="<?php echo e(route('admin.projects.destroy', $project)); ?>" method="POST" class="mt-2">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger w-100" 
                                onclick="return confirm('¿Estás seguro de eliminar este proyecto?')">
                            <i class="fas fa-trash me-2"></i>Eliminar Proyecto
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\edelvalle\resources\views/admin/projects/show.blade.php ENDPATH**/ ?>