<?php $__env->startSection('title', 'Gestión de Proyectos'); ?>
<?php $__env->startSection('page-title', 'Proyectos'); ?>

<?php $__env->startSection('page-actions'); ?>
<a href="<?php echo e(route('admin.projects.create')); ?>" class="btn btn-primary">
    <i class="fas fa-plus me-2"></i>Nuevo Proyecto
</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card shadow">
    <div class="card-body">
        <?php if($projects->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th width="80">Imagen</th>
                            <th>Título</th>
                            <th width="100">Estado</th>
                            <th width="100">Imágenes</th>
                            <th width="150">Fecha Creación</th>
                            <th width="150">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php if($project->mainImage): ?>
                                    <img src="<?php echo e($project->mainImage->image_url); ?>" 
                                         class="img-thumbnail" 
                                         style="width: 60px; height: 60px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="width: 60px; height: 60px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?php echo e($project->title); ?></strong>
                                <br>
                                <small class="text-muted"><?php echo e(Str::limit($project->description, 60)); ?></small>
                            </td>
                            <td>
                                <span class="badge <?php echo e($project->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                                    <?php echo e($project->is_active ? 'Activo' : 'Inactivo'); ?>

                                </span>
                            </td>
                            <td>
                                <span class="badge bg-info"><?php echo e($project->images->count()); ?></span>
                                <?php if($project->mainImage): ?>
                                    <br><small class="text-success">Principal: ✓</small>
                                <?php else: ?>
                                    <br><small class="text-danger">Sin principal</small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($project->created_at->format('d/m/Y H:i')); ?></td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.projects.show', $project)); ?>" 
                                       class="btn btn-info btn-sm" title="Ver">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.projects.edit', $project)); ?>" 
                                       class="btn btn-warning btn-sm" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.projects.destroy', $project)); ?>" 
                                          method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" 
                                                onclick="return confirm('¿Estás seguro de eliminar este proyecto?')"
                                                title="Eliminar">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($projects->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-folder-open fa-5x text-muted mb-4"></i>
                <h4 class="text-muted">No hay proyectos registrados</h4>
                <p class="text-muted">Comienza creando tu primer proyecto.</p>
                <a href="<?php echo e(route('admin.projects.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Crear Proyecto
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\edelvalle\resources\views/admin/projects/index.blade.php ENDPATH**/ ?>