<?php $__env->startSection('title', 'Inicio - Energia del Valle SPA'); ?>
<?php $__env->startSection('description', 'Empresa chilena especializada en instalaciones eléctricas, mantenimiento de redes y proyectos eléctricos rurales y urbanos.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <h1 class="display-4 fw-bold mb-4" data-aos="fade-up">Expertos en Instalaciones Eléctricas</h1>
                <p class="lead mb-4" data-aos="fade-up" data-aos-delay="200">
                    Somos una empresa chilena que se origina en el año 2021, dedicados al mantenimiento de la distribución de redes eléctricas. 
                    Clasificados como entidad de primera necesidad para brindar servicios a la comunidad.
                </p>
                <div data-aos="fade-up" data-aos-delay="400">
                    <a href="<?php echo e(route('about')); ?>" class="btn btn-primary btn-lg me-3">Conoce Más</a>
                    <a href="<?php echo e(route('contact')); ?>" class="btn btn-outline-light btn-lg">Contactanos</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row text-center">
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="fas fa-hard-hat fa-3x me-3"></i>
                    <div>
                        <h3 class="fw-bold mb-0">14</h3>
                        <p class="mb-0">Trabajadores</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="fas fa-truck fa-3x me-3"></i>
                    <div>
                        <h3 class="fw-bold mb-0">2</h3>
                        <p class="mb-0">Brigadas</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="fas fa-tools fa-3x me-3"></i>
                    <div>
                        <h3 class="fw-bold mb-0">5+</h3>
                        <p class="mb-0">Vehículos</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="fas fa-calendar-alt fa-3x me-3"></i>
                    <div>
                        <h3 class="fw-bold mb-0">2021</h3>
                        <p class="mb-0">Fundada</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold" data-aos="fade-up">Nuestros Servicios</h2>
                <p class="lead text-muted" data-aos="fade-up" data-aos-delay="200">Soluciones integrales en instalaciones eléctricas</p>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-bolt fa-3x text-primary mb-3"></i>
                    <h5>Construcción de LMT y LBT</h5>
                    <p class="text-muted">Construcción de líneas de media y baja tensión con los más altos estándares de calidad.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-lightbulb fa-3x text-primary mb-3"></i>
                    <h5>Alumbrado Público</h5>
                    <p class="text-muted">Instalación y mantenimiento de sistemas de alumbrado público para urbanizaciones.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-hammer fa-3x text-primary mb-3"></i>
                    <h5>Obras Civiles</h5>
                    <p class="text-muted">Ejecución de obras civiles complementarias para proyectos eléctricos.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-road fa-3x text-primary mb-3"></i>
                    <h5>Líneas Subterráneas</h5>
                    <p class="text-muted">Instalación y mantenimiento de líneas eléctricas subterráneas.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="400">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-home fa-3x text-primary mb-3"></i>
                    <h5>Construcción de Loteos</h5>
                    <p class="text-muted">Desarrollo de infraestructura eléctrica para nuevos loteos residenciales.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="500">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-plug fa-3x text-primary mb-3"></i>
                    <h5>Empalmes Eléctricos</h5>
                    <p class="text-muted">Construcción de empalmes monofásicos y trifásicos certificados.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Projects Section -->
<?php if($projects->count() > 0): ?>
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold" data-aos="fade-up">Proyectos Destacados</h2>
                <p class="lead text-muted" data-aos="fade-up" data-aos-delay="200">Algunos de nuestros trabajos más recientes</p>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $projects->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 mb-4" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                <div class="card project-card h-100">
                    <?php if($project->images->first()): ?>
                        <img src="<?php echo e(asset('storage/' . $project->images->first()->image_path)); ?>" 
                             class="card-img-top" style="height: 250px; object-fit: cover;" 
                             alt="<?php echo e($project->title); ?>">
                    <?php else: ?>
                        <img src="/placeholder.svg?height=250&width=400&query=electrical+project+<?php echo e($loop->index); ?>" 
                             class="card-img-top" style="height: 250px; object-fit: cover;" 
                             alt="<?php echo e($project->title); ?>">
                    <?php endif; ?>
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($project->title); ?></h5>
                        <p class="card-text"><?php echo e(Str::limit($project->description, 100)); ?></p>
                        <a href="<?php echo e(route('project.detail', $project->id)); ?>" class="btn btn-primary">Ver Detalles</a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="text-center mt-4">
            <a href="<?php echo e(route('projects')); ?>" class="btn btn-outline-primary btn-lg">Ver Todos los Proyectos</a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8" data-aos="fade-right">
                <h3 class="fw-bold mb-3">¿Necesitas una solución eléctrica?</h3>
                <p class="lead mb-0">Contáctanos para una consulta gratuita y cotización personalizada</p>
            </div>
            <div class="col-lg-4 text-lg-end" data-aos="fade-left">
                <a href="<?php echo e(route('contact')); ?>" class="btn btn-light btn-lg">Solicitar Cotización</a>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\edelvalle\resources\views/home.blade.php ENDPATH**/ ?>