<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\ProjectController as AdminProjectController;
use App\Http\Controllers\Admin\EmailSettingController;
use Illuminate\Support\Facades\Route;

// Rutas públicas (estas son las que se ven primero)
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/nosotros', [HomeController::class, 'about'])->name('about');
Route::get('/servicios', [HomeController::class, 'services'])->name('services');
Route::get('/equipo', [HomeController::class, 'team'])->name('team');
Route::get('/proyectos', [HomeController::class, 'projects'])->name('projects');
Route::get('/proyecto/{id}', [HomeController::class, 'projectDetail'])->name('project.detail');
Route::get('/contacto', [HomeController::class, 'contact'])->name('contact');
Route::post('/contacto', [ContactController::class, 'send'])->name('contact.send');

// Rutas de autenticación (solo para admin)
Auth::routes(['register' => false]);

// Redirección después del login
Route::get('/home', function () {
    if (auth()->check() && auth()->user()->is_admin) {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('home');
})->name('home.redirect');

// Rutas de administración
Route::prefix('admin')->name('admin.')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Gestión de proyectos
    Route::resource('projects', AdminProjectController::class);
    
    // Rutas específicas para gestión de imágenes
    Route::delete('projects/image/{imageId}', [AdminProjectController::class, 'deleteImage'])->name('projects.delete-image');
    Route::post('projects/image/{imageId}/set-main', [AdminProjectController::class, 'setMainImage'])->name('projects.set-main-image');
    
    // Rutas de debug (TEMPORALES)
    Route::get('projects/debug/permissions', [AdminProjectController::class, 'debugPermissions']);
    Route::post('projects/debug/setup', [AdminProjectController::class, 'setupDirectories']);
    
    // Configuración de email
    Route::get('email-settings', [EmailSettingController::class, 'index'])->name('email-settings.index');
    Route::post('email-settings', [EmailSettingController::class, 'store'])->name('email-settings.store');

    // Configuración del sitio
    Route::get('site-settings', [App\Http\Controllers\Admin\SiteSettingController::class, 'index'])->name('site-settings.index');
    Route::post('site-settings', [App\Http\Controllers\Admin\SiteSettingController::class, 'store'])->name('site-settings.store');
    Route::post('site-settings/reset-colors', [App\Http\Controllers\Admin\SiteSettingController::class, 'resetColors'])->name('site-settings.reset-colors');
});
