@extends('layouts.app')

@section('title', 'Nuestro Equipo - Energia del Valle SPA')
@section('description', 'Conoce al equipo profesional de Energia del Valle SPA, especialistas en instalaciones eléctricas.')

@section('content')
<!-- Hero Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-3" data-aos="fade-up">Nuestro Equipo</h1>
                <p class="lead" data-aos="fade-up" data-aos-delay="200">Profesionales comprometidos con la excelencia</p>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="fw-bold" data-aos="fade-up">Liderazgo y Experiencia</h2>
                <p class="lead text-muted" data-aos="fade-up" data-aos-delay="200">Un equipo de 14 profesionales especializados</p>
            </div>
        </div>

        <!-- Leadership Team -->
        <div class="row justify-content-center mb-5">
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up">
                <div class="card team-card h-100 text-center">
                    <div class="card-body p-4">
                        <img src="/placeholder.svg?height=150&width=150&query=professional+man+electrical+engineer" 
                             class="rounded-circle mb-3" style="width: 120px; height: 120px; object-fit: cover;" 
                             alt="Pablo del Valle">
                        <h5 class="fw-bold">Pablo del Valle</h5>
                        <p class="text-primary mb-3">Representante Legal y Fundador</p>
                        <p class="text-muted small">
                            Líder visionario con amplia experiencia en el sector eléctrico. 
                            Fundador de Energia del Valle SPA en 2021, comprometido con la excelencia y la innovación.
                        </p>
                        <div class="mt-3">
                            <span class="badge bg-primary me-1">Liderazgo</span>
                            <span class="badge bg-secondary me-1">Gestión</span>
                            <span class="badge bg-success">Estrategia</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Team Stats -->
        <div class="row text-center mb-5">
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <i class="fas fa-users fa-3x text-primary mb-3"></i>
                        <h3 class="fw-bold text-primary">14</h3>
                        <p class="text-muted mb-0">Trabajadores Especializados</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <i class="fas fa-truck fa-3x text-primary mb-3"></i>
                        <h3 class="fw-bold text-primary">2</h3>
                        <p class="text-muted mb-0">Brigadas de Trabajo</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <i class="fas fa-tools fa-3x text-primary mb-3"></i>
                        <h3 class="fw-bold text-primary">5+</h3>
                        <p class="text-muted mb-0">Vehículos Especializados</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <i class="fas fa-calendar-alt fa-3x text-primary mb-3"></i>
                        <h3 class="fw-bold text-primary">3+</h3>
                        <p class="text-muted mb-0">Años de Experiencia</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Team Specializations -->
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h3 class="fw-bold" data-aos="fade-up">Especialidades de Nuestro Equipo</h3>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-hard-hat fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Técnicos Electricistas</h5>
                        <p class="text-muted">
                            Especialistas certificados en instalaciones eléctricas de media y baja tensión, 
                            con amplia experiencia en proyectos residenciales e industriales.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-cogs fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Ingenieros de Campo</h5>
                        <p class="text-muted">
                            Profesionales encargados de la supervisión técnica, planificación de proyectos 
                            y aseguramiento de la calidad en todas las instalaciones.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-clipboard-check fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Supervisores de Seguridad</h5>
                        <p class="text-muted">
                            Especialistas en seguridad laboral que garantizan el cumplimiento de todas 
                            las normativas y protocolos de seguridad en cada proyecto.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-wrench fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Operarios Especializados</h5>
                        <p class="text-muted">
                            Técnicos con experiencia en manejo de equipos especializados, 
                            instalación de postes y trabajos en altura.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="400">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-truck-loading fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Conductores Especializados</h5>
                        <p class="text-muted">
                            Operadores de vehículos especializados y equipos pesados, 
                            certificados para el transporte seguro de materiales eléctricos.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="500">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-headset fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold">Soporte Administrativo</h5>
                        <p class="text-muted">
                            Equipo de apoyo encargado de la coordinación logística, 
                            atención al cliente y gestión de proyectos.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Values Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h3 class="fw-bold" data-aos="fade-up">Nuestros Valores</h3>
                <p class="lead text-muted" data-aos="fade-up" data-aos-delay="200">Los principios que guían nuestro trabajo diario</p>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-shield-alt fa-2x"></i>
                    </div>
                    <h5 class="fw-bold">Seguridad</h5>
                    <p class="text-muted">La seguridad de nuestro equipo y clientes es nuestra máxima prioridad en cada proyecto.</p>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-award fa-2x"></i>
                    </div>
                    <h5 class="fw-bold">Calidad</h5>
                    <p class="text-muted">Utilizamos materiales de primera calidad y aplicamos los más altos estándares técnicos.</p>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-handshake fa-2x"></i>
                    </div>
                    <h5 class="fw-bold">Compromiso</h5>
                    <p class="text-muted">Nos comprometemos con cada proyecto, cumpliendo plazos y superando expectativas.</p>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-lightbulb fa-2x"></i>
                    </div>
                    <h5 class="fw-bold">Innovación</h5>
                    <p class="text-muted">Adoptamos nuevas tecnologías y métodos para ofrecer soluciones más eficientes.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Join Team CTA -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8" data-aos="fade-right">
                <h3 class="fw-bold mb-3">¿Quieres formar parte de nuestro equipo?</h3>
                <p class="lead mb-0">Estamos siempre en búsqueda de profesionales talentosos y comprometidos</p>
            </div>
            <div class="col-lg-4 text-lg-end" data-aos="fade-left">
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">
                    <i class="fas fa-user-plus me-2"></i>Únete a Nosotros
                </a>
            </div>
        </div>
    </div>
</section>
@endsection

@push('styles')
<style>
.team-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.team-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}
</style>
@endpush
