@extends('layouts.app')

@section('title', 'Servicios - Energia del Valle SPA')
@section('description', 'Conoce todos los servicios de instalaciones eléctricas que ofrece Energia del Valle SPA.')

@section('content')
<!-- Hero Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-3" data-aos="fade-up">Nuestros Servicios</h1>
                <p class="lead" data-aos="fade-up" data-aos-delay="200">Soluciones integrales en instalaciones eléctricas</p>
            </div>
        </div>
    </div>
</section>

<!-- Services Grid -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-bolt fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Construcción de LMT y LBT</h4>
                    <p class="text-muted mb-4">
                        Construcción de líneas de media y baja tensión con los más altos estándares de calidad y seguridad.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Líneas de Media Tensión</li>
                        <li><i class="fas fa-check text-success me-2"></i>Líneas de Baja Tensión</li>
                        <li><i class="fas fa-check text-success me-2"></i>Instalación de Postes</li>
                        <li><i class="fas fa-check text-success me-2"></i>Tendido de Cables</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-lightbulb fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Instalación de Alumbrado Público</h4>
                    <p class="text-muted mb-4">
                        Instalación y mantenimiento de sistemas de alumbrado público para urbanizaciones y espacios públicos.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Luminarias LED</li>
                        <li><i class="fas fa-check text-success me-2"></i>Sistemas de Control</li>
                        <li><i class="fas fa-check text-success me-2"></i>Mantenimiento Preventivo</li>
                        <li><i class="fas fa-check text-success me-2"></i>Eficiencia Energética</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-hammer fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Obras Civiles</h4>
                    <p class="text-muted mb-4">
                        Ejecución de obras civiles complementarias necesarias para proyectos eléctricos.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Excavaciones</li>
                        <li><i class="fas fa-check text-success me-2"></i>Fundaciones</li>
                        <li><i class="fas fa-check text-success me-2"></i>Canalizaciones</li>
                        <li><i class="fas fa-check text-success me-2"></i>Pavimentación</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-road fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Líneas Eléctricas Subterráneas</h4>
                    <p class="text-muted mb-4">
                        Instalación y mantenimiento de líneas eléctricas subterráneas para zonas urbanas.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Cables Subterráneos</li>
                        <li><i class="fas fa-check text-success me-2"></i>Ductos y Cámaras</li>
                        <li><i class="fas fa-check text-success me-2"></i>Empalmes Especializados</li>
                        <li><i class="fas fa-check text-success me-2"></i>Pruebas Eléctricas</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="400">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-home fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Construcción de Loteos</h4>
                    <p class="text-muted mb-4">
                        Desarrollo de infraestructura eléctrica completa para nuevos loteos residenciales.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Diseño Eléctrico</li>
                        <li><i class="fas fa-check text-success me-2"></i>Red de Distribución</li>
                        <li><i class="fas fa-check text-success me-2"></i>Alumbrado Público</li>
                        <li><i class="fas fa-check text-success me-2"></i>Conexiones Domiciliarias</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="500">
                <div class="card service-card h-100 text-center p-4">
                    <i class="fas fa-plug fa-4x text-primary mb-4"></i>
                    <h4 class="fw-bold mb-3">Empalmes Eléctricos</h4>
                    <p class="text-muted mb-4">
                        Construcción de empalmes monofásicos y trifásicos certificados según normativa vigente.
                    </p>
                    <ul class="list-unstyled text-start">
                        <li><i class="fas fa-check text-success me-2"></i>Empalmes Monofásicos</li>
                        <li><i class="fas fa-check text-success me-2"></i>Empalmes Trifásicos</li>
                        <li><i class="fas fa-check text-success me-2"></i>Medidores Digitales</li>
                        <li><i class="fas fa-check text-success me-2"></i>Certificación SEC</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Process Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="fw-bold" data-aos="fade-up">Nuestro Proceso de Trabajo</h2>
                <p class="lead text-muted" data-aos="fade-up" data-aos-delay="200">Metodología probada para garantizar resultados exitosos</p>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <span class="h3 mb-0">1</span>
                    </div>
                    <h5 class="fw-bold">Evaluación</h5>
                    <p class="text-muted">Análisis detallado del proyecto y evaluación técnica del sitio.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <span class="h3 mb-0">2</span>
                    </div>
                    <h5 class="fw-bold">Planificación</h5>
                    <p class="text-muted">Diseño del proyecto y planificación de recursos necesarios.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <span class="h3 mb-0">3</span>
                    </div>
                    <h5 class="fw-bold">Ejecución</h5>
                    <p class="text-muted">Implementación del proyecto con los más altos estándares de calidad.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <span class="h3 mb-0">4</span>
                    </div>
                    <h5 class="fw-bold">Entrega</h5>
                    <p class="text-muted">Pruebas finales, certificación y entrega del proyecto terminado.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6" data-aos="fade-right">
                <h2 class="fw-bold mb-4">¿Por Qué Elegirnos?</h2>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-shield-alt text-primary me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold">Seguridad</h6>
                                <small class="text-muted">Cumplimos con todas las normativas de seguridad</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-clock text-primary me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold">Puntualidad</h6>
                                <small class="text-muted">Entregamos proyectos en tiempo y forma</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-award text-primary me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold">Calidad</h6>
                                <small class="text-muted">Materiales y mano de obra de primera calidad</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-headset text-primary me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold">Soporte</h6>
                                <small class="text-muted">Atención personalizada y soporte técnico</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <img src="/placeholder.svg?height=400&width=600&query=electrical+workers+safety+equipment" 
                     class="img-fluid rounded shadow" alt="Equipo de trabajo con equipos de seguridad">
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8" data-aos="fade-right">
                <h3 class="fw-bold mb-3">¿Necesitas alguno de nuestros servicios?</h3>
                <p class="lead mb-0">Contáctanos para una evaluación gratuita y cotización personalizada</p>
            </div>
            <div class="col-lg-4 text-lg-end" data-aos="fade-left">
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">
                    <i class="fas fa-phone me-2"></i>Solicitar Cotización
                </a>
            </div>
        </div>
    </div>
</section>
@endsection
