@extends('layouts.app')

@section('title', 'Proyectos - Energia del Valle SPA')
@section('description', 'Conoce nuestros proyectos de instalaciones eléctricas realizados en la región.')

@section('content')
<!-- Hero Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-3" data-aos="fade-up">Nuestros Proyectos</h1>
                <p class="lead" data-aos="fade-up" data-aos-delay="200">Trabajos realizados con excelencia y profesionalismo</p>
            </div>
        </div>
    </div>
</section>

<!-- Projects Grid -->
<section class="py-5">
    <div class="container">
        @if($projects->count() > 0)
            <div class="row">
                @foreach($projects as $project)
                <div class="col-lg-4 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="{{ $loop->index * 100 }}">
                    <div class="card project-card h-100">
                        @if($project->images->first())
                            <img src="{{ asset('storage/' . $project->images->first()->image_path) }}" 
                                 class="card-img-top" style="height: 250px; object-fit: cover;" 
                                 alt="{{ $project->title }}">
                        @else
                            <img src="/placeholder.svg?height=250&width=400&query=electrical+project+{{ $loop->index }}" 
                                 class="card-img-top" style="height: 250px; object-fit: cover;" 
                                 alt="{{ $project->title }}">
                        @endif
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title">{{ $project->title }}</h5>
                            <p class="card-text flex-grow-1">{{ Str::limit($project->description, 120) }}</p>
                            <div class="mt-auto">
                                <a href="{{ route('project.detail', $project->id) }}" class="btn btn-primary">Ver Detalles</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-5">
                {{ $projects->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-folder-open fa-5x text-muted mb-4"></i>
                <h3 class="text-muted">No hay proyectos disponibles</h3>
                <p class="text-muted">Pronto estaremos agregando nuestros proyectos más destacados.</p>
            </div>
        @endif
    </div>
</section>
@endsection
