@extends('layouts.app')

@section('title', $project->title . ' - Energia del Valle SPA')
@section('description', Str::limit($project->description, 160))

@section('content')
<!-- Hero Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-light">Inicio</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('projects') }}" class="text-light">Proyectos</a></li>
                        <li class="breadcrumb-item active text-light" aria-current="page">{{ $project->title }}</li>
                    </ol>
                </nav>
                <h1 class="display-5 fw-bold mb-3" data-aos="fade-up">{{ $project->title }}</h1>
            </div>
        </div>
    </div>
</section>

<!-- Project Detail -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <!-- Project Images -->
                @if($project->images->count() > 0)
                <div class="mb-4" data-aos="fade-up">
                    <div id="projectCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner rounded">
                            @foreach($project->images->sortBy('order') as $image)
                            <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                <img src="{{ asset('storage/' . $image->image_path) }}" 
                                     class="d-block w-100" style="height: 400px; object-fit: cover;" 
                                     alt="{{ $image->alt_text ?: $project->title }}"
                                     onerror="this.src='/placeholder.svg?height=400&width=800&query=electrical+project+detail'">
                            </div>
                            @endforeach
                        </div>
                        @if($project->images->count() > 1)
                        <button class="carousel-control-prev" type="button" data-bs-target="#projectCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon"></span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#projectCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon"></span>
                        </button>
                        @endif
                    </div>
                    
                    <!-- Thumbnails -->
                    @if($project->images->count() > 1)
                    <div class="row mt-3">
                        @foreach($project->images->sortBy('order') as $image)
                        <div class="col-2 mb-2">
                            <img src="{{ asset('storage/' . $image->image_path) }}" 
                                 class="img-thumbnail w-100" style="height: 60px; object-fit: cover; cursor: pointer;" 
                                 onclick="goToSlide({{ $loop->index }})"
                                 alt="Miniatura {{ $loop->iteration }}"
                                 onerror="this.src='/placeholder.svg?height=60&width=80&query=thumb'">
                        </div>
                        @endforeach
                    </div>
                    @endif
                </div>
                @else
                <div class="mb-4" data-aos="fade-up">
                    <img src="/placeholder.svg?height=400&width=800&query=electrical+project+detail" 
                         class="img-fluid rounded" style="height: 400px; width: 100%; object-fit: cover;" 
                         alt="{{ $project->title }}">
                </div>
                @endif

                <!-- Project Description -->
                <div data-aos="fade-up" data-aos-delay="200">
                    <h3 class="fw-bold mb-3">Descripción del Proyecto</h3>
                    <div class="text-muted" style="white-space: pre-line;">{{ $project->description }}</div>
                </div>

                <!-- Project Details -->
                <div class="mt-4" data-aos="fade-up" data-aos-delay="300">
                    <h4 class="fw-bold mb-3">Detalles Técnicos</h4>
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Instalación certificada</li>
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Materiales de primera calidad</li>
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Cumple normativas SEC</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Garantía de instalación</li>
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Soporte técnico</li>
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Mantenimiento disponible</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- Project Info -->
                <div class="card shadow mb-4" data-aos="fade-left">
                    <div class="card-header bg-primary text-white">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información del Proyecto</h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            <li class="mb-3">
                                <strong><i class="fas fa-calendar text-primary me-2"></i>Fecha de Registro:</strong><br>
                                <span class="text-muted">{{ $project->created_at->format('d/m/Y') }}</span>
                            </li>
                            <li class="mb-3">
                                <strong><i class="fas fa-toggle-on text-primary me-2"></i>Estado:</strong><br>
                                <span class="badge {{ $project->is_active ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $project->is_active ? 'Proyecto Activo' : 'Proyecto Inactivo' }}
                                </span>
                            </li>
                            <li class="mb-3">
                                <strong><i class="fas fa-images text-primary me-2"></i>Galería:</strong><br>
                                <span class="text-muted">{{ $project->images->count() }} imagen(es)</span>
                            </li>
                            <li class="mb-0">
                                <strong><i class="fas fa-tag text-primary me-2"></i>Categoría:</strong><br>
                                <span class="text-muted">Instalaciones Eléctricas</span>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Contact CTA -->
                <div class="card shadow mb-4" data-aos="fade-left" data-aos-delay="200">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-handshake fa-3x text-primary mb-3"></i>
                        <h5 class="fw-bold mb-3">¿Interesado en un proyecto similar?</h5>
                        <p class="text-muted mb-4">Contáctanos para una evaluación gratuita y cotización personalizada para tu proyecto eléctrico</p>
                        <a href="{{ route('contact') }}" class="btn btn-primary btn-lg w-100">
                            <i class="fas fa-envelope me-2"></i>Solicitar Cotización
                        </a>
                    </div>
                </div>

                <!-- Services CTA -->
                <div class="card shadow" data-aos="fade-left" data-aos-delay="300">
                    <div class="card-body text-center p-4">
                        <i class="fas fa-tools fa-3x text-secondary mb-3"></i>
                        <h6 class="fw-bold mb-3">Nuestros Servicios</h6>
                        <p class="text-muted small mb-3">Conoce todos los servicios que ofrecemos</p>
                        <a href="{{ route('services') }}" class="btn btn-outline-secondary w-100">
                            <i class="fas fa-list me-2"></i>Ver Servicios
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Projects -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h3 class="fw-bold" data-aos="fade-up">Otros Proyectos Destacados</h3>
                <p class="text-muted" data-aos="fade-up" data-aos-delay="200">Conoce más trabajos realizados por nuestro equipo</p>
            </div>
        </div>
        <div class="row">
            @php
                $relatedProjects = App\Models\Project::active()
                    ->where('id', '!=', $project->id)
                    ->with('images')
                    ->take(3)
                    ->get();
            @endphp
            
            @if($relatedProjects->count() > 0)
                @foreach($relatedProjects as $relatedProject)
                <div class="col-lg-4 mb-4" data-aos="fade-up" data-aos-delay="{{ $loop->index * 100 }}">
                    <div class="card project-card h-100">
                        @if($relatedProject->images->first())
                            <img src="{{ asset('storage/' . $relatedProject->images->first()->image_path) }}" 
                                 class="card-img-top" style="height: 200px; object-fit: cover;" 
                                 alt="{{ $relatedProject->title }}"
                                 onerror="this.src='/placeholder.svg?height=200&width=400&query=electrical+project+{{ $loop->index }}'">
                        @else
                            <img src="/placeholder.svg?height=200&width=400&query=electrical+project+{{ $loop->index }}" 
                                 class="card-img-top" style="height: 200px; object-fit: cover;" 
                                 alt="{{ $relatedProject->title }}">
                        @endif
                        <div class="card-body d-flex flex-column">
                            <h6 class="card-title">{{ $relatedProject->title }}</h6>
                            <p class="card-text flex-grow-1 small">{{ Str::limit($relatedProject->description, 80) }}</p>
                            <a href="{{ route('project.detail', $relatedProject->id) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-eye me-1"></i>Ver Detalles
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <div class="col-12 text-center">
                    <div class="py-5">
                        <i class="fas fa-folder-open fa-4x text-muted mb-3"></i>
                        <h5 class="text-muted">No hay otros proyectos disponibles</h5>
                        <p class="text-muted">Pronto estaremos agregando más proyectos destacados.</p>
                        <a href="{{ route('projects') }}" class="btn btn-outline-primary">
                            <i class="fas fa-arrow-left me-2"></i>Volver a Proyectos
                        </a>
                    </div>
                </div>
            @endif
        </div>
        
        @if($relatedProjects->count() > 0)
        <div class="text-center mt-4">
            <a href="{{ route('projects') }}" class="btn btn-outline-primary btn-lg">
                <i class="fas fa-th-large me-2"></i>Ver Todos los Proyectos
            </a>
        </div>
        @endif
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8" data-aos="fade-right">
                <h3 class="fw-bold mb-3">¿Tienes un proyecto en mente?</h3>
                <p class="lead mb-0">Nuestro equipo de expertos está listo para ayudarte a materializar tu proyecto eléctrico</p>
            </div>
            <div class="col-lg-4 text-lg-end" data-aos="fade-left">
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">
                    <i class="fas fa-phone me-2"></i>Contáctanos Ahora
                </a>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
// Función para ir a un slide específico del carousel
function goToSlide(slideIndex) {
    const carousel = new bootstrap.Carousel(document.getElementById('projectCarousel'));
    carousel.to(slideIndex);
}

// Auto-play del carousel (opcional)
document.addEventListener('DOMContentLoaded', function() {
    const carousel = document.getElementById('projectCarousel');
    if (carousel && carousel.querySelectorAll('.carousel-item').length > 1) {
        new bootstrap.Carousel(carousel, {
            interval: 5000,
            wrap: true
        });
    }
});
</script>
@endpush
