@php
    $siteSettings = App\Models\SiteSetting::getSettings();
@endphp
<!DOCTYPE html>
<html lang="es" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>@yield('title', $siteSettings->site_name . ' - ' . ($siteSettings->site_tagline ?: 'Instalaciones Eléctricas'))</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="@yield('description', 'Empresa chilena especializada en instalaciones eléctricas, mantenimiento de redes y proyectos eléctricos rurales y urbanos.')">
    
    @if($siteSettings->favicon_path)
        <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $siteSettings->favicon_path) }}">
    @endif
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: {{ $siteSettings->primary_color }};
            --secondary-color: {{ $siteSettings->secondary_color }};
            --success-color: {{ $siteSettings->success_color }};
            --warning-color: {{ $siteSettings->warning_color }};
            --danger-color: {{ $siteSettings->danger_color }};
            --dark-color: {{ $siteSettings->dark_color }};
        }
        
        .navbar-brand img {
            max-height: 50px;
        }
        
        .hero-section {
            background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), 
                        url('{{ $siteSettings->hero_background_image ? asset('storage/' . $siteSettings->hero_background_image) : 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=1200&q=80' }}');
            background-size: cover;
            background-position: center;
            min-height: 70vh;
            display: flex;
            align-items: center;
            color: white;
        }
        
        .service-card {
            transition: transform 0.3s ease;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .service-card:hover {
            transform: translateY(-5px);
        }
        
        .project-card {
            overflow: hidden;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        
        .project-card:hover {
            transform: translateY(-5px);
        }
        
        .footer {
            background-color: var(--dark-color);
            color: white;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .text-primary {
            color: var(--primary-color) !important;
        }
        
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        
        .border-left-primary {
            border-left: 4px solid var(--primary-color) !important;
        }
        
        .border-left-success {
            border-left: 4px solid var(--success-color) !important;
        }
        
        .border-left-info {
            border-left: 4px solid #17a2b8 !important;
        }
        
        .border-left-warning {
            border-left: 4px solid var(--warning-color) !important;
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}">
                @if($siteSettings->logo_path)
                    <img src="{{ asset('storage/' . $siteSettings->logo_path) }}" alt="{{ $siteSettings->site_name }}" class="img-fluid">
                @else
                    <img src="https://via.placeholder.com/150x50/{{ str_replace('#', '', $siteSettings->primary_color) }}/ffffff?text={{ urlencode($siteSettings->site_name) }}" alt="{{ $siteSettings->site_name }}" class="img-fluid">
                @endif
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('home') ? 'active' : '' }}" href="{{ route('home') }}">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}" href="{{ route('about') }}">Nosotros</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('services') ? 'active' : '' }}" href="{{ route('services') }}">Servicios</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('team') ? 'active' : '' }}" href="{{ route('team') }}">Equipo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('projects') ? 'active' : '' }}" href="{{ route('projects') }}">Proyectos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}" href="{{ route('contact') }}">Contacto</a>
                    </li>
                    @auth
                        @if(auth()->user()->is_admin)
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('admin.dashboard') }}">Panel Admin</a>
                            </li>
                        @endif
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('logout') }}" 
                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                Salir
                            </a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">Acceso Admin</a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="footer py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">{{ $siteSettings->site_name }}</h5>
                    <p class="text-light">
                        {{ $siteSettings->footer_text ?: 'Empresa chilena especializada en instalaciones eléctricas y mantenimiento de redes de distribución eléctrica desde 2021.' }}
                    </p>
                    @if($siteSettings->social_links)
                        <div class="d-flex">
                            @if(isset($siteSettings->social_links['facebook']))
                                <a href="{{ $siteSettings->social_links['facebook'] }}" class="text-light me-3" target="_blank"><i class="fab fa-facebook-f"></i></a>
                            @endif
                            @if(isset($siteSettings->social_links['twitter']))
                                <a href="{{ $siteSettings->social_links['twitter'] }}" class="text-light me-3" target="_blank"><i class="fab fa-twitter"></i></a>
                            @endif
                            @if(isset($siteSettings->social_links['linkedin']))
                                <a href="{{ $siteSettings->social_links['linkedin'] }}" class="text-light me-3" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                            @endif
                            @if(isset($siteSettings->social_links['instagram']))
                                <a href="{{ $siteSettings->social_links['instagram'] }}" class="text-light" target="_blank"><i class="fab fa-instagram"></i></a>
                            @endif
                        </div>
                    @endif
                </div>
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">Servicios</h5>
                    <ul class="list-unstyled text-light">
                        <li class="mb-2">Construcción de LMT y LBT</li>
                        <li class="mb-2">Instalación de Alumbrado Público</li>
                        <li class="mb-2">Obras Civiles</li>
                        <li class="mb-2">Líneas Eléctricas Subterráneas</li>
                        <li class="mb-2">Empalmes Monofásicos y Trifásicos</li>
                    </ul>
                </div>
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">Contacto</h5>
                    <div class="text-light">
                        <p class="mb-2"><i class="fas fa-map-marker-alt me-2"></i>Cerro Mejillón 1055, Parque Ñuble, Chillán</p>
                        <p class="mb-2"><i class="fas fa-phone me-2"></i>+56 9 3022 8380</p>
                        <p class="mb-2"><i class="fas fa-envelope me-2"></i>p.delvalle@energiadelvallespa.cl</p>
                        <p class="mb-0"><strong>RUT:</strong> 77.340.576-K</p>
                    </div>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="row">
                <div class="col-12 text-center">
                    <p class="text-light mb-0">&copy; {{ date('Y') }} {{ $siteSettings->site_name }}. Todos los derechos reservados.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- AOS Animation -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
    </script>
    
    @stack('scripts')
</body>
</html>
