@extends('admin.layouts.app')

@section('title', 'Configuración del Sitio')
@section('page-title', 'Configuración del Sitio Web')

@section('page-actions')
<form action="{{ route('admin.site-settings.reset-colors') }}" method="POST" class="d-inline">
    @csrf
    <button type="submit" class="btn btn-outline-secondary" 
            onclick="return confirm('¿Restablecer colores a los valores por defecto?')">
        <i class="fas fa-undo me-2"></i>Restablecer Colores
    </button>
</form>
@endsection

@section('content')
<form action="{{ route('admin.site-settings.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
    
    <div class="row">
        <!-- Información General -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información General</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="site_name" class="form-label">Nombre del Sitio *</label>
                        <input type="text" class="form-control @error('site_name') is-invalid @enderror" 
                               id="site_name" name="site_name" 
                               value="{{ old('site_name', $settings->site_name) }}" required>
                        @error('site_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="site_tagline" class="form-label">Eslogan/Tagline</label>
                        <input type="text" class="form-control @error('site_tagline') is-invalid @enderror" 
                               id="site_tagline" name="site_tagline" 
                               value="{{ old('site_tagline', $settings->site_tagline) }}"
                               placeholder="Ej: Instalaciones Eléctricas Profesionales">
                        @error('site_tagline')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="footer_text" class="form-label">Texto del Footer</label>
                        <textarea class="form-control @error('footer_text') is-invalid @enderror" 
                                  id="footer_text" name="footer_text" rows="3"
                                  placeholder="Texto personalizado para el pie de página">{{ old('footer_text', $settings->footer_text) }}</textarea>
                        @error('footer_text')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        <!-- Imágenes -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-images me-2"></i>Imágenes</h6>
                </div>
                <div class="card-body">
                    <!-- Logo -->
                    <div class="mb-3">
                        <label for="logo" class="form-label">Logo del Sitio</label>
                        @if($settings->logo_path)
                            <div class="mb-2">
                                <img src="{{ asset('storage/' . $settings->logo_path) }}" 
                                     alt="Logo actual" class="img-thumbnail" style="max-height: 60px;">
                                <small class="text-muted d-block">Logo actual</small>
                            </div>
                        @endif
                        <input type="file" class="form-control @error('logo') is-invalid @enderror" 
                               id="logo" name="logo" accept="image/*">
                        <div class="form-text">Formatos: JPG, PNG, GIF, SVG (máx. 2MB)</div>
                        @error('logo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Favicon -->
                    <div class="mb-3">
                        <label for="favicon" class="form-label">Favicon</label>
                        @if($settings->favicon_path)
                            <div class="mb-2">
                                <img src="{{ asset('storage/' . $settings->favicon_path) }}" 
                                     alt="Favicon actual" class="img-thumbnail" style="max-height: 32px;">
                                <small class="text-muted d-block">Favicon actual</small>
                            </div>
                        @endif
                        <input type="file" class="form-control @error('favicon') is-invalid @enderror" 
                               id="favicon" name="favicon" accept=".ico,.png">
                        <div class="form-text">Formatos: ICO, PNG (máx. 512KB)</div>
                        @error('favicon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Imagen de fondo del hero -->
                    <div class="mb-3">
                        <label for="hero_background" class="form-label">Imagen de Fondo Hero</label>
                        @if($settings->hero_background_image)
                            <div class="mb-2">
                                <img src="{{ asset('storage/' . $settings->hero_background_image) }}" 
                                     alt="Fondo hero actual" class="img-thumbnail" style="max-height: 100px;">
                                <small class="text-muted d-block">Imagen actual</small>
                            </div>
                        @endif
                        <input type="file" class="form-control @error('hero_background') is-invalid @enderror" 
                               id="hero_background" name="hero_background" accept="image/*">
                        <div class="form-text">Formatos: JPG, PNG (máx. 5MB)</div>
                        @error('hero_background')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        <!-- Colores -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-palette me-2"></i>Colores del Sitio</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="primary_color" class="form-label">Color Primario</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('primary_color') is-invalid @enderror" 
                                       id="primary_color" name="primary_color" 
                                       value="{{ old('primary_color', $settings->primary_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('primary_color', $settings->primary_color) }}" readonly>
                            </div>
                            @error('primary_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="secondary_color" class="form-label">Color Secundario</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('secondary_color') is-invalid @enderror" 
                                       id="secondary_color" name="secondary_color" 
                                       value="{{ old('secondary_color', $settings->secondary_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('secondary_color', $settings->secondary_color) }}" readonly>
                            </div>
                            @error('secondary_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="success_color" class="form-label">Color Éxito</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('success_color') is-invalid @enderror" 
                                       id="success_color" name="success_color" 
                                       value="{{ old('success_color', $settings->success_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('success_color', $settings->success_color) }}" readonly>
                            </div>
                            @error('success_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="warning_color" class="form-label">Color Advertencia</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('warning_color') is-invalid @enderror" 
                                       id="warning_color" name="warning_color" 
                                       value="{{ old('warning_color', $settings->warning_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('warning_color', $settings->warning_color) }}" readonly>
                            </div>
                            @error('warning_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="danger_color" class="form-label">Color Peligro</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('danger_color') is-invalid @enderror" 
                                       id="danger_color" name="danger_color" 
                                       value="{{ old('danger_color', $settings->danger_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('danger_color', $settings->danger_color) }}" readonly>
                            </div>
                            @error('danger_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="dark_color" class="form-label">Color Oscuro</label>
                            <div class="input-group">
                                <input type="color" class="form-control form-control-color @error('dark_color') is-invalid @enderror" 
                                       id="dark_color" name="dark_color" 
                                       value="{{ old('dark_color', $settings->dark_color) }}">
                                <input type="text" class="form-control" 
                                       value="{{ old('dark_color', $settings->dark_color) }}" readonly>
                            </div>
                            @error('dark_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Redes Sociales -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-share-alt me-2"></i>Redes Sociales</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="facebook_url" class="form-label">Facebook</label>
                        <input type="url" class="form-control @error('facebook_url') is-invalid @enderror" 
                               id="facebook_url" name="facebook_url" 
                               value="{{ old('facebook_url', $settings->social_links['facebook'] ?? '') }}"
                               placeholder="https://facebook.com/tu-pagina">
                        @error('facebook_url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="twitter_url" class="form-label">Twitter</label>
                        <input type="url" class="form-control @error('twitter_url') is-invalid @enderror" 
                               id="twitter_url" name="twitter_url" 
                               value="{{ old('twitter_url', $settings->social_links['twitter'] ?? '') }}"
                               placeholder="https://twitter.com/tu-cuenta">
                        @error('twitter_url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="linkedin_url" class="form-label">LinkedIn</label>
                        <input type="url" class="form-control @error('linkedin_url') is-invalid @enderror" 
                               id="linkedin_url" name="linkedin_url" 
                               value="{{ old('linkedin_url', $settings->social_links['linkedin'] ?? '') }}"
                               placeholder="https://linkedin.com/company/tu-empresa">
                        @error('linkedin_url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="instagram_url" class="form-label">Instagram</label>
                        <input type="url" class="form-control @error('instagram_url') is-invalid @enderror" 
                               id="instagram_url" name="instagram_url" 
                               value="{{ old('instagram_url', $settings->social_links['instagram'] ?? '') }}"
                               placeholder="https://instagram.com/tu-cuenta">
                        @error('instagram_url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botones de acción -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Volver al Dashboard
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Guardar Configuración
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
// Sincronizar color picker con input de texto
document.querySelectorAll('input[type="color"]').forEach(colorInput => {
    const textInput = colorInput.nextElementSibling;
    
    colorInput.addEventListener('input', function() {
        textInput.value = this.value;
    });
});
</script>
@endpush
