@extends('admin.layouts.app')

@section('title', 'Ver Proyecto')
@section('page-title', 'Proyecto: ' . $project->title)

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('admin.projects.edit', $project) }}" class="btn btn-warning">
        <i class="fas fa-edit me-2"></i>Editar
    </a>
    <a href="{{ route('project.detail', $project->id) }}" target="_blank" class="btn btn-info">
        <i class="fas fa-external-link-alt me-2"></i>Ver en Sitio
    </a>
</div>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-body">
                <h3 class="fw-bold mb-3">{{ $project->title }}</h3>
                
                <div class="mb-4">
                    <h5>Descripción:</h5>
                    <p class="text-muted" style="white-space: pre-line;">{{ $project->description }}</p>
                </div>

                @if($project->images->count() > 0)
                <div class="mb-4">
                    <h5>Imágenes del Proyecto:</h5>
                    <div class="row">
                        @foreach($project->images as $image)
                        <div class="col-md-6 col-lg-4 mb-3">
                            <img src="{{ asset('storage/' . $image->image_path) }}" 
                                 class="img-fluid rounded shadow" 
                                 alt="{{ $image->alt_text }}"
                                 data-bs-toggle="modal" 
                                 data-bs-target="#imageModal{{ $image->id }}"
                                 style="cursor: pointer;">
                        </div>

                        <!-- Modal para imagen -->
                        <div class="modal fade" id="imageModal{{ $image->id }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">{{ $project->title }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <img src="{{ asset('storage/' . $image->image_path) }}" 
                                             class="img-fluid" alt="{{ $image->alt_text }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card shadow">
            <div class="card-header">
                <h6 class="mb-0">Información del Proyecto</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <strong>Estado:</strong>
                        <span class="badge {{ $project->is_active ? 'bg-success' : 'bg-secondary' }} ms-2">
                            {{ $project->is_active ? 'Activo' : 'Inactivo' }}
                        </span>
                    </li>
                    <li class="mb-2">
                        <strong>Fecha de Creación:</strong><br>
                        {{ $project->created_at->format('d/m/Y H:i') }}
                    </li>
                    <li class="mb-2">
                        <strong>Última Actualización:</strong><br>
                        {{ $project->updated_at->format('d/m/Y H:i') }}
                    </li>
                    <li class="mb-2">
                        <strong>Total de Imágenes:</strong><br>
                        {{ $project->images->count() }} imagen(es)
                    </li>
                </ul>
            </div>
        </div>

        <div class="card shadow mt-4">
            <div class="card-header">
                <h6 class="mb-0">Acciones</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.projects.edit', $project) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Editar Proyecto
                    </a>
                    <a href="{{ route('project.detail', $project->id) }}" target="_blank" class="btn btn-info">
                        <i class="fas fa-external-link-alt me-2"></i>Ver en Sitio Web
                    </a>
                    <a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Volver a Lista
                    </a>
                    <form action="{{ route('admin.projects.destroy', $project) }}" method="POST" class="mt-2">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100" 
                                onclick="return confirm('¿Estás seguro de eliminar este proyecto?')">
                            <i class="fas fa-trash me-2"></i>Eliminar Proyecto
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
