@extends('admin.layouts.app')

@section('title', 'Gestión de Proyectos')
@section('page-title', 'Proyectos')

@section('page-actions')
<a href="{{ route('admin.projects.create') }}" class="btn btn-primary">
    <i class="fas fa-plus me-2"></i>Nuevo Proyecto
</a>
@endsection

@section('content')
<div class="card shadow">
    <div class="card-body">
        @if($projects->count() > 0)
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th width="80">Imagen</th>
                            <th>Título</th>
                            <th width="100">Estado</th>
                            <th width="100">Imágenes</th>
                            <th width="150">Fecha Creación</th>
                            <th width="150">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($projects as $project)
                        <tr>
                            <td>
                                @if($project->mainImage)
                                    <img src="{{ $project->mainImage->image_url }}" 
                                         class="img-thumbnail" 
                                         style="width: 60px; height: 60px; object-fit: cover;">
                                @else
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="width: 60px; height: 60px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                @endif
                            </td>
                            <td>
                                <strong>{{ $project->title }}</strong>
                                <br>
                                <small class="text-muted">{{ Str::limit($project->description, 60) }}</small>
                            </td>
                            <td>
                                <span class="badge {{ $project->is_active ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $project->is_active ? 'Activo' : 'Inactivo' }}
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $project->images->count() }}</span>
                                @if($project->mainImage)
                                    <br><small class="text-success">Principal: ✓</small>
                                @else
                                    <br><small class="text-danger">Sin principal</small>
                                @endif
                            </td>
                            <td>{{ $project->created_at->format('d/m/Y H:i') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.projects.show', $project) }}" 
                                       class="btn btn-info btn-sm" title="Ver">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.projects.edit', $project) }}" 
                                       class="btn btn-warning btn-sm" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.projects.destroy', $project) }}" 
                                          method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" 
                                                onclick="return confirm('¿Estás seguro de eliminar este proyecto?')"
                                                title="Eliminar">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $projects->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-folder-open fa-5x text-muted mb-4"></i>
                <h4 class="text-muted">No hay proyectos registrados</h4>
                <p class="text-muted">Comienza creando tu primer proyecto.</p>
                <a href="{{ route('admin.projects.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Crear Proyecto
                </a>
            </div>
        @endif
    </div>
</div>
@endsection
