@extends('admin.layouts.app')

@section('title', 'Configuración de Email')
@section('page-title', 'Configuración de Email')

@section('content')
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-header">
                <h6 class="mb-0">Configuración SMTP</h6>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.email-settings.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="smtp_host" class="form-label">Servidor SMTP *</label>
                            <input type="text" class="form-control @error('smtp_host') is-invalid @enderror" 
                                   id="smtp_host" name="smtp_host" 
                                   value="{{ old('smtp_host', $emailSetting->smtp_host ?? 'smtp.gmail.com') }}" required>
                            @error('smtp_host')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="smtp_port" class="form-label">Puerto SMTP *</label>
                            <input type="text" class="form-control @error('smtp_port') is-invalid @enderror" 
                                   id="smtp_port" name="smtp_port" 
                                   value="{{ old('smtp_port', $emailSetting->smtp_port ?? '587') }}" required>
                            @error('smtp_port')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="smtp_username" class="form-label">Usuario SMTP *</label>
                            <input type="email" class="form-control @error('smtp_username') is-invalid @enderror" 
                                   id="smtp_username" name="smtp_username" 
                                   value="{{ old('smtp_username', $emailSetting->smtp_username ?? '') }}" required>
                            @error('smtp_username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="smtp_password" class="form-label">Contraseña SMTP *</label>
                            <input type="password" class="form-control @error('smtp_password') is-invalid @enderror" 
                                   id="smtp_password" name="smtp_password" 
                                   placeholder="{{ $emailSetting ? 'Dejar en blanco para mantener actual' : 'Contraseña SMTP' }}" 
                                   {{ $emailSetting ? '' : 'required' }}>
                            @error('smtp_password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="smtp_encryption" class="form-label">Encriptación *</label>
                        <select class="form-select @error('smtp_encryption') is-invalid @enderror" 
                                id="smtp_encryption" name="smtp_encryption" required>
                            <option value="tls" {{ old('smtp_encryption', $emailSetting->smtp_encryption ?? 'tls') == 'tls' ? 'selected' : '' }}>TLS</option>
                            <option value="ssl" {{ old('smtp_encryption', $emailSetting->smtp_encryption ?? '') == 'ssl' ? 'selected' : '' }}>SSL</option>
                        </select>
                        @error('smtp_encryption')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="from_email" class="form-label">Email Remitente *</label>
                            <input type="email" class="form-control @error('from_email') is-invalid @enderror" 
                                   id="from_email" name="from_email" 
                                   value="{{ old('from_email', $emailSetting->from_email ?? 'contacto@energiadelvallespa.cl') }}" required>
                            @error('from_email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="from_name" class="form-label">Nombre Remitente *</label>
                            <input type="text" class="form-control @error('from_name') is-invalid @enderror" 
                                   id="from_name" name="from_name" 
                                   value="{{ old('from_name', $emailSetting->from_name ?? 'Energia del Valle SPA') }}" required>
                            @error('from_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="contact_email" class="form-label">Email de Contacto *</label>
                        <input type="email" class="form-control @error('contact_email') is-invalid @enderror" 
                               id="contact_email" name="contact_email" 
                               value="{{ old('contact_email', $emailSetting->contact_email ?? 'p.delvalle@energiadelvallespa.cl') }}" required>
                        <div class="form-text">Los mensajes del formulario de contacto se enviarán a este email</div>
                        @error('contact_email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Volver
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Guardar Configuración
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card shadow">
            <div class="card-header">
                <h6 class="mb-0">Información</h6>
            </div>
            <div class="card-body">
                <h6>Configuración Gmail:</h6>
                <ul class="list-unstyled mb-3">
                    <li><strong>Servidor:</strong> smtp.gmail.com</li>
                    <li><strong>Puerto:</strong> 587</li>
                    <li><strong>Encriptación:</strong> TLS</li>
                </ul>
                
                <div class="alert alert-warning">
                    <small>
                        <i class="fas fa-exclamation-triangle me-1"></i>
                        Para Gmail, necesitas usar una "Contraseña de aplicación" en lugar de tu contraseña normal.
                    </small>
                </div>
                
                <h6>Estado Actual:</h6>
                @if($emailSetting)
                    <span class="badge bg-success">Configurado</span>
                    <p class="small mt-2 mb-0">
                        Última actualización: {{ $emailSetting->updated_at->format('d/m/Y H:i') }}
                    </p>
                @else
                    <span class="badge bg-warning">Sin configurar</span>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
