@extends('admin.layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Configuración del Sitio</h1>
        <div class="flex space-x-2">
            <a href="{{ route('admin.cms.clear-cache') }}" 
               class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded-lg">
                <i class="fas fa-sync-alt mr-2"></i>Limpiar Caché
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('admin.cms.site-config.update') }}" method="POST" enctype="multipart/form-data">
        @csrf
        
        @foreach($configs as $group => $groupConfigs)
            <div class="bg-white rounded-lg shadow-md mb-6">
                <div class="bg-gray-50 px-6 py-4 border-b">
                    <h2 class="text-xl font-semibold text-gray-800 capitalize">
                        @switch($group)
                            @case('company') Información de la Empresa @break
                            @case('design') Diseño y Apariencia @break
                            @case('seo') SEO y Analytics @break
                            @case('pages') Configuración de Páginas @break
                            @default {{ ucfirst($group) }}
                        @endswitch
                    </h2>
                </div>
                
                <div class="p-6 space-y-6">
                    @foreach($groupConfigs as $config)
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-start">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">
                                    {{ $config->label }}
                                </label>
                                @if($config->description)
                                    <p class="text-xs text-gray-500">{{ $config->description }}</p>
                                @endif
                            </div>
                            
                            <div class="md:col-span-2">
                                @switch($config->type)
                                    @case('textarea')
                                        <textarea name="{{ $config->key }}" 
                                                rows="4" 
                                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent">{{ $config->value }}</textarea>
                                        @break
                                    
                                    @case('color')
                                        <div class="flex items-center space-x-2">
                                            <input type="color" 
                                                   name="{{ $config->key }}" 
                                                   value="{{ $config->value }}"
                                                   class="w-12 h-10 border border-gray-300 rounded">
                                            <input type="text" 
                                                   value="{{ $config->value }}"
                                                   class="flex-1 border border-gray-300 rounded-lg px-3 py-2"
                                                   readonly>
                                        </div>
                                        @break
                                    
                                    @case('image')
                                        <div class="space-y-2">
                                            @if($config->value)
                                                <div class="mb-2">
                                                    <img src="{{ asset($config->value) }}" 
                                                         alt="Imagen actual" 
                                                         class="max-w-xs h-20 object-contain border rounded">
                                                </div>
                                            @endif
                                            <input type="file" 
                                                   name="{{ $config->key }}" 
                                                   accept="image/*"
                                                   class="w-full border border-gray-300 rounded-lg px-3 py-2">
                                        </div>
                                        @break
                                    
                                    @case('email')
                                        <input type="email" 
                                               name="{{ $config->key }}" 
                                               value="{{ $config->value }}"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                        @break
                                    
                                    @default
                                        <input type="text" 
                                               name="{{ $config->key }}" 
                                               value="{{ $config->value }}"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                @endswitch
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach

        <div class="flex justify-end">
            <button type="submit" 
                    class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded-lg font-medium">
                <i class="fas fa-save mr-2"></i>Guardar Configuración
            </button>
        </div>
    </form>
</div>
@endsection
