@extends('admin.layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Gestión de Secciones</h1>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            {{ session('success') }}
        </div>
    @endif

    <div class="grid gap-6">
        @foreach($sections as $section)
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <div class="bg-gray-50 px-6 py-4 border-b flex justify-between items-center">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">{{ $section->title }}</h3>
                        <p class="text-sm text-gray-600">Clave: {{ $section->key }}</p>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="px-2 py-1 text-xs rounded-full {{ $section->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ $section->is_active ? 'Activa' : 'Inactiva' }}
                        </span>
                        <a href="{{ route('admin.cms.sections.edit', $section) }}" 
                           class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded text-sm">
                            <i class="fas fa-edit mr-1"></i>Editar
                        </a>
                    </div>
                </div>
                
                <div class="p-6">
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <div class="prose max-w-none">
                                {!! Str::limit(nl2br(e($section->content)), 300) !!}
                            </div>
                        </div>
                        @if($section->image)
                            <div>
                                <img src="{{ asset($section->image) }}" 
                                     alt="{{ $section->title }}" 
                                     class="w-full h-32 object-cover rounded-lg">
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection
