@extends('admin.layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Editar Sección: {{ $section->title }}</h1>
        <a href="{{ route('admin.cms.sections.index') }}" 
           class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg">
            <i class="fas fa-arrow-left mr-2"></i>Volver
        </a>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.cms.sections.update', $section) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <div class="bg-white rounded-lg shadow-md p-6 space-y-6">
            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Título</label>
                    <input type="text" 
                           name="title" 
                           value="{{ old('title', $section->title) }}"
                           class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Orden</label>
                    <input type="number" 
                           name="order" 
                           value="{{ old('order', $section->order) }}"
                           class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Contenido</label>
                <textarea name="content" 
                          rows="10" 
                          class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                          required>{{ old('content', $section->content) }}</textarea>
                <p class="text-sm text-gray-500 mt-1">Puedes usar Markdown para formatear el texto</p>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Imagen</label>
                @if($section->image)
                    <div class="mb-4">
                        <img src="{{ asset($section->image) }}" 
                             alt="Imagen actual" 
                             class="max-w-xs h-32 object-cover rounded-lg border">
                    </div>
                @endif
                <input type="file" 
                       name="image" 
                       accept="image/*"
                       class="w-full border border-gray-300 rounded-lg px-3 py-2">
            </div>

            <!-- Configuraciones adicionales según la sección -->
            @if(in_array($section->key, ['hero', 'contact']))
                <div class="border-t pt-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Configuraciones Adicionales</h3>
                    
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Texto del Botón</label>
                            <input type="text" 
                                   name="button_text" 
                                   value="{{ old('button_text', $section->settings['button_text'] ?? '') }}"
                                   class="w-full border border-gray-300 rounded-lg px-3 py-2">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">URL del Botón</label>
                            <input type="text" 
                                   name="button_url" 
                                   value="{{ old('button_url', $section->settings['button_url'] ?? '') }}"
                                   class="w-full border border-gray-300 rounded-lg px-3 py-2">
                        </div>
                    </div>
                </div>
            @endif

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Color de Fondo</label>
                    <input type="color" 
                           name="background_color" 
                           value="{{ old('background_color', $section->settings['background_color'] ?? '#ffffff') }}"
                           class="w-full h-10 border border-gray-300 rounded-lg">
                </div>
                
                <div class="flex items-center">
                    <input type="checkbox" 
                           name="is_active" 
                           id="is_active"
                           {{ old('is_active', $section->is_active) ? 'checked' : '' }}
                           class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                    <label for="is_active" class="ml-2 block text-sm text-gray-900">
                        Sección activa
                    </label>
                </div>
            </div>

            <div class="flex justify-end space-x-4">
                <a href="{{ route('admin.cms.sections.index') }}" 
                   class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded-lg">
                    Cancelar
                </a>
                <button type="submit" 
                        class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded-lg">
                    <i class="fas fa-save mr-2"></i>Guardar Cambios
                </button>
            </div>
        </div>
    </form>
</div>
@endsection
