@extends('layouts.app')

@section('title', 'Nosotros - Energia del Valle SPA')
@section('description', 'Conoce más sobre Energia del Valle SPA, empresa chilena especializada en instalaciones eléctricas desde 2021.')

@section('content')
<!-- Hero Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-3" data-aos="fade-up">Quiénes Somos</h1>
                <p class="lead" data-aos="fade-up" data-aos-delay="200">Energia del Valle SPA - Instalaciones Eléctricas</p>
            </div>
        </div>
    </div>
</section>

<!-- About Content -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center mb-5">
            <div class="col-lg-6" data-aos="fade-right">
                <h2 class="fw-bold mb-4">Nuestra Historia</h2>
                <p class="lead">
                    Somos una empresa chilena que se origina en el año 2021, dedicados al mantenimiento de la distribución de redes eléctricas.
                </p>
                <p>
                    Nuestra empresa se encuentra clasificada como una entidad de primera necesidad o de emergencia, lo que implica que, ante cualquier catástrofe natural, como temporales o terremotos, somos los primeros en brindar servicios a la comunidad, trabajando en las redes eléctricas.
                </p>
                <p>
                    Con sede en Cerro Mejillón 1055, Parque Ñuble, Chillán, nos hemos consolidado como una empresa confiable en el sector eléctrico de la región.
                </p>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <img src="/placeholder.svg?height=400&width=600&query=electrical+company+team+working" 
                     class="img-fluid rounded shadow" alt="Equipo de trabajo Energia del Valle">
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 mb-4" data-aos="fade-up">
                <div class="card h-100 border-0 shadow">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <i class="fas fa-eye fa-3x text-primary"></i>
                        </div>
                        <h3 class="text-center fw-bold mb-4">Visión</h3>
                        <p>
                            Luchamos por ser reconocidos como líderes en la región, en el sector de mantención eléctrica, destacándonos por nuestra excelencia operativa, innovación tecnológica y compromiso con la seguridad de nuestros clientes.
                        </p>
                        <p>
                            Aspiramos a ser el socio estratégico preferido de nuestros clientes, contribuyendo al desarrollo de una infraestructura eléctrica confiable y al progreso energético sostenible.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card h-100 border-0 shadow">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <i class="fas fa-bullseye fa-3x text-primary"></i>
                        </div>
                        <h3 class="text-center fw-bold mb-4">Misión</h3>
                        <p>
                            En Energia del Valle velamos por proveer soluciones integrales y de alta calidad en la mantención eléctrica, asegurando la continuidad y seguridad del suministro a nuestros clientes.
                        </p>
                        <p>
                            Nos comprometemos a utilizar tecnología avanzada, cumplir con los más altos estándares de seguridad y satisfacer las necesidades específicas de nuestros clientes, contribuyendo al desarrollo confiable y eficiente de la infraestructura eléctrica.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Company Info -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="fw-bold" data-aos="fade-up">Información General</h2>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card border-0 shadow" data-aos="fade-up">
                    <div class="card-body p-5">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <strong>Razón Social:</strong><br>
                                ENERGIA DEL VALLE SPA
                            </div>
                            <div class="col-md-6 mb-3">
                                <strong>RUT:</strong><br>
                                77.340.576-K
                            </div>
                            <div class="col-md-6 mb-3">
                                <strong>Giro:</strong><br>
                                Instalaciones Eléctricas y Otras Obras para Construcción
                            </div>
                            <div class="col-md-6 mb-3">
                                <strong>Representante Legal:</strong><br>
                                Pablo del Valle
                            </div>
                            <div class="col-md-6 mb-3">
                                <strong>Email:</strong><br>
                                <a href="mailto:p.delvalle@energiadelvallespa.cl">p.delvalle@energiadelvallespa.cl</a>
                            </div>
                            <div class="col-md-6 mb-3">
                                <strong>Teléfono:</strong><br>
                                <a href="tel:+56930228380">+56 9 3022 8380</a>
                            </div>
                            <div class="col-12">
                                <strong>Dirección:</strong><br>
                                Cerro Mejillón 1055, Parque Ñuble, Chillán
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8" data-aos="fade-right">
                <h3 class="fw-bold mb-3">¿Quieres trabajar con nosotros?</h3>
                <p class="lead mb-0">Contáctanos para conocer más sobre nuestros servicios y cómo podemos ayudarte</p>
            </div>
            <div class="col-lg-4 text-lg-end" data-aos="fade-left">
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">Contactanos</a>
            </div>
        </div>
    </div>
</section>
@endsection
