<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SiteConfig;

class SiteConfigSeeder extends Seeder
{
    public function run()
    {
        $configs = [
            // Información de la empresa
            [
                'key' => 'site_title',
                'value' => 'Energía del Valle SPA',
                'type' => 'text',
                'group' => 'company',
                'label' => 'Nombre de la Empresa',
                'description' => 'Nombre principal que aparecerá en el sitio web',
                'order' => 1
            ],
            [
                'key' => 'site_description',
                'value' => 'Empresa líder en servicios eléctricos industriales y residenciales con más de 15 años de experiencia en el mercado chileno.',
                'type' => 'textarea',
                'group' => 'company',
                'label' => 'Descripción de la Empresa',
                'description' => 'Descripción breve que aparece en el sitio y SEO',
                'order' => 2
            ],
            [
                'key' => 'company_phone',
                'value' => '+56 9 8765 4321',
                'type' => 'text',
                'group' => 'company',
                'label' => 'Teléfono',
                'description' => 'Número de teléfono principal',
                'order' => 3
            ],
            [
                'key' => 'company_email',
                'value' => 'contacto@energiadelvallespa.cl',
                'type' => 'email',
                'group' => 'company',
                'label' => 'Email',
                'description' => 'Email de contacto principal',
                'order' => 4
            ],
            [
                'key' => 'company_address',
                'value' => 'Av. Providencia 1234, Santiago, Chile',
                'type' => 'text',
                'group' => 'company',
                'label' => 'Dirección',
                'description' => 'Dirección física de la empresa',
                'order' => 5
            ],
            [
                'key' => 'company_hours',
                'value' => 'Lunes a Viernes 8:00 - 18:00, Sábados 9:00 - 13:00',
                'type' => 'text',
                'group' => 'company',
                'label' => 'Horarios de Atención',
                'description' => 'Horarios de atención al cliente',
                'order' => 6
            ],
            
            // Configuración de diseño
            [
                'key' => 'primary_color',
                'value' => '#1f2937',
                'type' => 'color',
                'group' => 'design',
                'label' => 'Color Primario',
                'description' => 'Color principal del sitio web',
                'order' => 1
            ],
            [
                'key' => 'secondary_color',
                'value' => '#3b82f6',
                'type' => 'color',
                'group' => 'design',
                'label' => 'Color Secundario',
                'description' => 'Color secundario para acentos',
                'order' => 2
            ],
            [
                'key' => 'logo_url',
                'value' => '/placeholder.svg?height=60&width=200&text=Energía+del+Valle',
                'type' => 'image',
                'group' => 'design',
                'label' => 'Logo',
                'description' => 'Logo principal de la empresa',
                'order' => 3
            ],
            
            // SEO
            [
                'key' => 'meta_keywords',
                'value' => 'servicios eléctricos, instalaciones eléctricas, mantención eléctrica, proyectos eléctricos, Chile',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Palabras Clave',
                'description' => 'Palabras clave para SEO (separadas por comas)',
                'order' => 1
            ],
            [
                'key' => 'google_analytics',
                'value' => '',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Google Analytics ID',
                'description' => 'ID de Google Analytics (ej: GA-XXXXXXXXX)',
                'order' => 2
            ],
            
            // Configuración de páginas
            [
                'key' => 'projects_page_title',
                'value' => 'Nuestros Proyectos',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Título Página Proyectos',
                'description' => 'Título que aparece en la página de proyectos',
                'order' => 1
            ],
            [
                'key' => 'projects_page_description',
                'value' => 'Conoce todos nuestros proyectos eléctricos realizados con la más alta calidad y profesionalismo.',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => 'Descripción Página Proyectos',
                'description' => 'Descripción que aparece en la página de proyectos',
                'order' => 2
            ],
        ];

        foreach ($configs as $config) {
            SiteConfig::create($config);
        }
    }
}
