<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Section;

class SectionSeeder extends Seeder
{
    public function run()
    {
        $sections = [
            [
                'key' => 'hero',
                'title' => 'Energía del Valle SPA',
                'content' => 'Somos una empresa líder en servicios eléctricos industriales y residenciales. Con más de 15 años de experiencia, ofrecemos soluciones integrales de alta calidad para todos sus proyectos eléctricos.',
                'image' => '/placeholder.svg?height=600&width=1200&text=Hero+Eléctrico',
                'settings' => [
                    'button_text' => 'Ver Proyectos',
                    'button_url' => '/proyectos',
                    'background_color' => '#1f2937'
                ],
                'is_active' => true,
                'order' => 1
            ],
            [
                'key' => 'about',
                'title' => 'Acerca de Nosotros',
                'content' => 'Energía del Valle SPA es una empresa chilena especializada en servicios eléctricos integrales. Fundada en 2008, hemos crecido hasta convertirnos en una de las empresas más confiables del sector eléctrico en Chile.

Nuestro equipo está conformado por profesionales altamente calificados y certificados, comprometidos con la excelencia en cada proyecto. Trabajamos con las últimas tecnologías y seguimos estrictamente las normativas de seguridad vigentes.

**Nuestros Valores:**
- Calidad y excelencia en cada proyecto
- Seguridad como prioridad absoluta
- Innovación y tecnología de vanguardia
- Compromiso con nuestros clientes
- Responsabilidad ambiental',
                'image' => '/placeholder.svg?height=400&width=600&text=Equipo+Técnico',
                'settings' => [
                    'background_color' => '#f9fafb'
                ],
                'is_active' => true,
                'order' => 2
            ],
            [
                'key' => 'services',
                'title' => 'Nuestros Servicios',
                'content' => 'Ofrecemos una amplia gama de servicios eléctricos para satisfacer todas las necesidades de nuestros clientes:

**Servicios Industriales:**
- Instalaciones eléctricas industriales
- Mantención preventiva y correctiva
- Automatización industrial
- Sistemas de control y monitoreo
- Eficiencia energética

**Servicios Residenciales:**
- Instalaciones eléctricas domiciliarias
- Reparaciones y mantención
- Sistemas de iluminación LED
- Instalación de sistemas solares
- Certificaciones eléctricas

**Servicios Comerciales:**
- Proyectos eléctricos comerciales
- Sistemas de emergencia
- Iluminación especializada
- Sistemas de seguridad eléctrica',
                'image' => '/placeholder.svg?height=400&width=600&text=Servicios+Eléctricos',
                'settings' => [
                    'background_color' => '#ffffff'
                ],
                'is_active' => true,
                'order' => 3
            ],
            [
                'key' => 'contact',
                'title' => 'Contáctanos',
                'content' => '¿Necesitas servicios eléctricos profesionales? Estamos aquí para ayudarte. Contáctanos para una cotización gratuita y sin compromiso.

**¿Por qué elegirnos?**
- Más de 15 años de experiencia
- Técnicos certificados y especializados
- Garantía en todos nuestros trabajos
- Atención 24/7 para emergencias
- Precios competitivos y transparentes

No dudes en contactarnos para cualquier consulta o proyecto que tengas en mente. Nuestro equipo estará encantado de asesorarte.',
                'image' => '/placeholder.svg?height=400&width=600&text=Contacto+Profesional',
                'settings' => [
                    'button_text' => 'Solicitar Cotización',
                    'button_url' => 'mailto:contacto@energiadelvallespa.cl',
                    'background_color' => '#f3f4f6'
                ],
                'is_active' => true,
                'order' => 4
            ]
        ];

        foreach ($sections as $section) {
            Section::create($section);
        }
    }
}
