<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class PageSeeder extends Seeder
{
    public function run()
    {
        $pages = [
            [
                'title' => 'Política de Privacidad',
                'slug' => 'politica-de-privacidad',
                'content' => '# Política de Privacidad

## Información que Recopilamos
En Energía del Valle SPA, respetamos su privacidad y nos comprometemos a proteger la información personal que nos proporciona.

## Uso de la Información
La información que recopilamos se utiliza únicamente para:
- Proporcionar nuestros servicios
- Comunicarnos con usted
- Mejorar nuestros servicios

## Protección de Datos
Implementamos medidas de seguridad apropiadas para proteger su información personal contra acceso no autorizado, alteración, divulgación o destrucción.

## Contacto
Si tiene preguntas sobre esta política de privacidad, puede contactarnos en contacto@energiadelvallespa.cl',
                'meta_description' => 'Política de privacidad de Energía del Valle SPA',
                'meta_keywords' => 'política privacidad, protección datos, energía del valle',
                'is_active' => true,
                'show_in_menu' => false,
                'menu_order' => 0
            ],
            [
                'title' => 'Términos y Condiciones',
                'slug' => 'terminos-y-condiciones',
                'content' => '# Términos y Condiciones

## Aceptación de Términos
Al utilizar nuestros servicios, usted acepta estos términos y condiciones.

## Servicios
Energía del Valle SPA se compromete a proporcionar servicios eléctricos de alta calidad siguiendo todas las normativas vigentes.

## Responsabilidades
- El cliente debe proporcionar acceso seguro al área de trabajo
- Energía del Valle SPA garantiza trabajos realizados según normativas
- Todos los trabajos incluyen garantía según tipo de servicio

## Modificaciones
Nos reservamos el derecho de modificar estos términos en cualquier momento.

## Contacto
Para consultas sobre estos términos, contacte a contacto@energiadelvallespa.cl',
                'meta_description' => 'Términos y condiciones de servicios de Energía del Valle SPA',
                'meta_keywords' => 'términos condiciones, servicios eléctricos, energía del valle',
                'is_active' => true,
                'show_in_menu' => false,
                'menu_order' => 0
            ],
            [
                'title' => 'Certificaciones',
                'slug' => 'certificaciones',
                'content' => '# Nuestras Certificaciones

## Certificaciones Técnicas
Energía del Valle SPA cuenta con todas las certificaciones necesarias para operar en el sector eléctrico chileno:

### SEC (Superintendencia de Electricidad y Combustibles)
- Instalador Eléctrico Clase A
- Mantenedor Eléctrico Autorizado
- Certificación para trabajos en alta tensión

### Otras Certificaciones
- ISO 9001:2015 - Gestión de Calidad
- ISO 14001:2015 - Gestión Ambiental
- OHSAS 18001 - Seguridad y Salud Ocupacional

## Equipo Certificado
Nuestro equipo técnico cuenta con:
- Técnicos electricistas certificados
- Ingenieros eléctricos colegiados
- Especialistas en automatización industrial
- Expertos en eficiencia energética

## Compromiso con la Calidad
Mantenemos nuestras certificaciones actualizadas y seguimos mejorando continuamente nuestros procesos para ofrecer el mejor servicio a nuestros clientes.',
                'meta_description' => 'Certificaciones y acreditaciones de Energía del Valle SPA',
                'meta_keywords' => 'certificaciones, SEC, ISO, electricistas certificados',
                'is_active' => true,
                'show_in_menu' => true,
                'menu_order' => 3
            ]
        ];

        foreach ($pages as $page) {
            Page::create($page);
        }
    }
}
