<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Project;
use App\Models\EmailSetting;
use App\Models\SiteSetting;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Crear usuario administrador
        User::create([
            'name' => 'Administrador',
            'email' => 'admin@energiadelvallespa.cl',
            'password' => Hash::make('admin123'),
            'is_admin' => true,
        ]);

        // Crear configuración de email por defecto
        EmailSetting::create([
            'smtp_host' => 'smtp.gmail.com',
            'smtp_port' => '587',
            'smtp_username' => 'contacto@energiadelvallespa.cl',
            'smtp_password' => '',
            'smtp_encryption' => 'tls',
            'from_email' => 'contacto@energiadelvallespa.cl',
            'from_name' => 'Energia del Valle SPA',
            'contact_email' => 'p.delvalle@energiadelvallespa.cl',
        ]);

        // Crear configuración del sitio por defecto
        SiteSetting::create([
            'site_name' => 'Energia del Valle SPA',
            'site_tagline' => 'Instalaciones Eléctricas Profesionales',
            'primary_color' => '#007bff',
            'secondary_color' => '#6c757d',
            'success_color' => '#28a745',
            'warning_color' => '#ffc107',
            'danger_color' => '#dc3545',
            'dark_color' => '#343a40',
            'footer_text' => 'Empresa chilena especializada en instalaciones eléctricas y mantenimiento de redes de distribución eléctrica desde 2021.',
            'social_links' => [
                'facebook' => 'https://facebook.com/energiadelvallespa',
                'linkedin' => 'https://linkedin.com/company/energia-del-valle-spa',
            ],
        ]);

        // Crear proyectos de ejemplo
        $projects = [
            [
                'title' => 'Instalación de Red Eléctrica Rural - Sector Los Aromos',
                'description' => 'Proyecto de electrificación rural que benefició a 45 familias del sector Los Aromos, incluyendo instalación de postes, tendido de cables y conexiones domiciliarias.',
                'is_active' => true,
            ],
            [
                'title' => 'Mantenimiento Red de Distribución Urbana',
                'description' => 'Mantenimiento preventivo y correctivo de la red de distribución eléctrica en el centro de Chillán, incluyendo cambio de conductores y modernización de equipos.',
                'is_active' => true,
            ],
            [
                'title' => 'Construcción de Línea de Media Tensión',
                'description' => 'Construcción de 5 km de línea de media tensión para alimentar nuevo conjunto habitacional, con instalación de transformadores y equipos de protección.',
                'is_active' => true,
            ],
        ];

        foreach ($projects as $projectData) {
            Project::create($projectData);
        }
    }
}
