<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Eliminar tabla existente si existe
        Schema::dropIfExists('project_images');
        
        // Crear nueva tabla con estructura simplificada
        Schema::create('project_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->string('image_path');
            $table->string('original_name')->nullable();
            $table->boolean('is_main')->default(false); // Imagen principal
            $table->integer('order')->default(0);
            $table->bigInteger('file_size')->nullable();
            $table->timestamps();
            
            // Índices para mejor rendimiento
            $table->index(['project_id', 'is_main']);
            $table->index(['project_id', 'order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_images');
    }
};
