<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_images', function (Blueprint $table) {
            // Agregar campos adicionales para mejor organización
            $table->string('original_name')->nullable()->after('image_path');
            $table->string('file_size')->nullable()->after('original_name');
            $table->string('mime_type')->nullable()->after('file_size');
            $table->timestamp('uploaded_at')->nullable()->after('mime_type');
            
            // Índices para mejor rendimiento
            $table->index(['project_id', 'order']);
            $table->index('uploaded_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_images', function (Blueprint $table) {
            $table->dropIndex(['project_id', 'order']);
            $table->dropIndex(['uploaded_at']);
            $table->dropColumn(['original_name', 'file_size', 'mime_type', 'uploaded_at']);
        });
    }
};
