<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_name',
        'site_tagline',
        'logo_path',
        'favicon_path',
        'primary_color',
        'secondary_color',
        'success_color',
        'warning_color',
        'danger_color',
        'dark_color',
        'hero_background_image',
        'footer_text',
        'social_links',
    ];

    protected $casts = [
        'social_links' => 'array',
    ];

    public static function getSettings()
    {
        return static::first() ?? new static();
    }
}
