<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class SiteConfig extends Model
{
    use HasFactory;

    protected $fillable = [
        'key', 'value', 'type', 'group', 'label', 'description', 'order'
    ];

    public static function get($key, $default = null)
    {
        return Cache::remember("site_config_{$key}", 3600, function () use ($key, $default) {
            $config = self::where('key', $key)->first();
            return $config ? $config->value : $default;
        });
    }

    public static function set($key, $value)
    {
        $config = self::updateOrCreate(['key' => $key], ['value' => $value]);
        Cache::forget("site_config_{$key}");
        return $config;
    }

    public static function getByGroup($group)
    {
        return Cache::remember("site_config_group_{$group}", 3600, function () use ($group) {
            return self::where('group', $group)->orderBy('order')->get();
        });
    }

    public static function clearCache()
    {
        $keys = self::pluck('key');
        foreach ($keys as $key) {
            Cache::forget("site_config_{$key}");
        }
        
        $groups = self::distinct('group')->pluck('group');
        foreach ($groups as $group) {
            Cache::forget("site_config_group_{$group}");
        }
    }
}
