<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Section extends Model
{
    use HasFactory;

    protected $fillable = [
        'key', 'title', 'content', 'image', 'settings', 'is_active', 'order'
    ];

    protected $casts = [
        'settings' => 'array',
        'is_active' => 'boolean',
    ];

    public static function getByKey($key)
    {
        return self::where('key', $key)->where('is_active', true)->first();
    }

    public static function getActive()
    {
        return self::where('is_active', true)->orderBy('order')->get();
    }
}
