<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'slug', 'content', 'meta_description', 'meta_keywords',
        'is_active', 'show_in_menu', 'menu_order'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'show_in_menu' => 'boolean',
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public static function getMenuPages()
    {
        return self::where('is_active', true)
                  ->where('show_in_menu', true)
                  ->orderBy('menu_order')
                  ->get();
    }
}
