<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $projects = Project::active()->with('images')->latest()->take(6)->get();
        
        return view('home', compact('projects'));
    }

    public function about()
    {
        return view('about');
    }

    public function services()
    {
        return view('services');
    }

    public function team()
    {
        return view('team');
    }

    public function projects()
    {
        $projects = Project::active()->with('images')->paginate(9);
        
        return view('projects', compact('projects'));
    }

    public function projectDetail($id)
    {
        $project = Project::active()->with('images')->findOrFail($id);
        
        return view('project-detail', compact('project'));
    }

    public function contact()
    {
        return view('contact');
    }
}
