<?php

namespace App\Http\Controllers;

use App\Models\EmailSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Config;

class ContactController extends Controller
{
    public function send(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'subject' => 'required|string|max:255',
            'message' => 'required|string|max:2000',
        ]);

        try {
            // Obtener configuración de email
            $emailSettings = EmailSetting::first();
            
            if ($emailSettings) {
                // Configurar dinámicamente el mail
                Config::set('mail.mailers.smtp.host', $emailSettings->smtp_host);
                Config::set('mail.mailers.smtp.port', $emailSettings->smtp_port);
                Config::set('mail.mailers.smtp.username', $emailSettings->smtp_username);
                Config::set('mail.mailers.smtp.password', $emailSettings->smtp_password);
                Config::set('mail.mailers.smtp.encryption', $emailSettings->smtp_encryption);
                Config::set('mail.from.address', $emailSettings->from_email);
                Config::set('mail.from.name', $emailSettings->from_name);

                // Enviar email
                Mail::send('emails.contact', [
                    'contactName' => $request->name,
                    'contactEmail' => $request->email,
                    'contactPhone' => $request->phone,
                    'contactSubject' => $request->subject,
                    'contactMessage' => $request->message,
                ], function ($message) use ($emailSettings, $request) {
                    $message->to($emailSettings->contact_email)
                           ->subject('Nuevo mensaje de contacto: ' . $request->subject);
                });

                return back()->with('success', 'Mensaje enviado correctamente. Nos pondremos en contacto contigo pronto.');
            }

            return back()->with('error', 'Error en la configuración de email. Por favor contacta directamente.');

        } catch (\Exception $e) {
            return back()->with('error', 'Error al enviar el mensaje. Por favor intenta nuevamente.');
        }
    }
}
