<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmailSetting;
use Illuminate\Http\Request;

class EmailSettingController extends Controller
{
    public function index()
    {
        $emailSetting = EmailSetting::first();
        return view('admin.email-settings.index', compact('emailSetting'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'smtp_host' => 'required|string',
            'smtp_port' => 'required|string',
            'smtp_username' => 'required|string',
            'smtp_password' => 'required|string',
            'smtp_encryption' => 'required|string',
            'from_email' => 'required|email',
            'from_name' => 'required|string',
            'contact_email' => 'required|email',
        ]);

        EmailSetting::updateOrCreate(
            ['id' => 1],
            $request->all()
        );

        return redirect()->route('admin.email-settings.index')
                        ->with('success', 'Configuración de email actualizada exitosamente.');
    }
}
