<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Project;
use App\Models\User;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function dashboard()
    {
        $stats = [
            'total_projects' => Project::count(),
            'active_projects' => Project::active()->count(),
            'total_users' => User::count(),
            'recent_projects' => Project::latest()->take(5)->get(),
        ];

        return view('admin.dashboard', compact('stats'));
    }
}
