# Energia del Valle SPA - Sistema Web

Sistema web desarrollado en Laravel 10 para la empresa Energia del Valle SPA, especializada en instalaciones eléctricas.

## 🚀 Instalación Rápida

### 1. Descargar e Instalar
\`\`\`bash
# Descomprimir el archivo descargado
cd energia-del-valle-complete

# Instalar dependencias
composer install

# Configurar entorno
cp .env.example .env
php artisan key:generate

# Instalar Laravel UI
composer require laravel/ui
php artisan ui bootstrap --auth
\`\`\`

### 2. Configurar Base de Datos
\`\`\`bash
# Crear base de datos MySQL
CREATE DATABASE energia_del_valle;

# Ejecutar migraciones y seeders
php artisan migrate
php artisan db:seed

# Crear enlace de storage (IMPORTANTE)
php artisan storage:link
\`\`\`

### 3. Configurar Permisos (Linux/Mac)
\`\`\`bash
# Dar permisos a directorios de storage
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
chmod -R 755 public/storage/

# Si tienes problemas con imágenes
sudo chown -R www-data:www-data storage/
sudo chown -R www-data:www-data public/storage/
\`\`\`

### 4. Iniciar Servidor
\`\`\`bash
php artisan serve
\`\`\`

## 🔑 Credenciales de Acceso
- **Email:** admin@energiadelvallespa.cl
- **Contraseña:** admin123

## 📋 Características Nuevas
- ✅ Sistema de imágenes mejorado con carpetas por proyecto
- ✅ Optimización automática de imágenes grandes
- ✅ Información detallada de archivos (tamaño, fecha, etc.)
- ✅ Verificación de integridad de archivos
- ✅ Panel de debug mejorado para diagnóstico
- ✅ Gestión avanzada de imágenes principales

## 🌐 URLs del Sistema
- **Sitio Web:** http://localhost:8000
- **Panel Admin:** http://localhost:8000/login
- **Dashboard:** http://localhost:8000/admin/dashboard

## 🔧 Solución de Problemas

### Problema: Las imágenes no se cargan
1. Verificar que existe el symlink: `ls -la public/storage`
2. Recrear symlink: `php artisan storage:link`
3. Verificar permisos: `chmod -R 755 storage/`

### Problema: Error al subir imágenes
1. Verificar tamaño máximo en php.ini: `upload_max_filesize = 10M`
2. Verificar permisos de escritura en storage/
3. Usar el panel de debug en editar proyecto

### Panel de Debug
En la página de editar proyecto hay botones para:
- **Check Simple**: Verificación básica del sistema
- **Crear Dirs**: Crear directorios necesarios automáticamente
- **Storage**: Verificar estado del almacenamiento
- **Symlink**: Crear/verificar enlace simbólico
- **Archivos**: Listar archivos en storage

¡Listo para usar! 🎉
